/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import guideme.Guide;
import guideme.GuidePage;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.indices.CategoryIndex;
import guideme.indices.ItemIndex;
import guideme.internal.GuideOnStartup;
import guideme.internal.siteexport.CacheBusting;
import guideme.internal.siteexport.ExportFeedbackSink;
import guideme.internal.siteexport.OffScreenRenderer;
import guideme.internal.siteexport.SiteExportWriter;
import guideme.internal.siteexport.TextureDownloader;
import guideme.internal.siteexport.WebPExporter;
import guideme.internal.siteexport.mdastpostprocess.PageExportPostProcessor;
import guideme.internal.util.Platform;
import guideme.navigation.NavigationNode;
import guideme.siteexport.ExportableResourceProvider;
import guideme.siteexport.ResourceExporter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.FurnaceRecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.crafting.display.StonecutterRecipeDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.display.FluidStackContentsFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteExporter
implements ResourceExporter {
    private static final Logger LOG = LoggerFactory.getLogger(SiteExporter.class);
    private final Minecraft client;
    private final Map<ResourceLocation, String> exportedTextures = new HashMap<ResourceLocation, String>();
    private final Path outputFolder;
    private final Guide guide;
    private ParsedGuidePage currentPage;
    private final Set<RecipeHolder<?>> recipes = new HashSet();
    private final Set<Item> items = new HashSet<Item>();
    private final Set<Fluid> fluids = new HashSet<Fluid>();

    public SiteExporter(Minecraft client, Path outputFolder, Guide guide) {
        this.client = client;
        this.outputFolder = outputFolder;
        this.guide = guide;
    }

    public void exportOnNextTickAndExit() {
        MutableBoolean exportDone = new MutableBoolean();
        NeoForge.EVENT_BUS.addListener(evt -> {
            if (this.client.getOverlay() instanceof LoadingOverlay) {
                return;
            }
            if (!exportDone.getValue().booleanValue()) {
                exportDone.setTrue();
                try {
                    this.export();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                this.client.stop();
            }
        });
    }

    public void export(ExportFeedbackSink feedback) {
        try {
            this.export();
            feedback.sendFeedback((Component)Component.literal((String)"Guide data exported to ").append((Component)Component.literal((String)("[" + this.outputFolder.getFileName().toString() + "]")).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.OpenFile(this.outputFolder.toString())).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)"Click to open export folder"))).applyFormats(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            feedback.sendError((Component)Component.literal((String)e.toString()));
        }
    }

    @Override
    public void referenceItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            this.items.add(stack.getItem());
            if (!stack.getComponentsPatch().isEmpty()) {
                LOG.error("Couldn't handle stack with NBT tag: {}", (Object)stack);
            }
        }
    }

    @Override
    public void referenceFluid(Fluid fluid) {
        this.fluids.add(fluid);
    }

    public void referenceFluid(FluidStack fluid) {
        this.fluids.add(fluid.getFluid());
    }

    @Override
    public void referenceRecipe(RecipeHolder<?> holder) {
        if (!this.recipes.add(holder)) {
            return;
        }
        for (RecipeDisplay recipeDisplay : holder.value().display()) {
            this.visitDisplays(recipeDisplay, display -> {
                display.resolve(Platform.getSlotDisplayContext(), (DisplayContentsFactory)SlotDisplay.ItemStackContentsFactory.INSTANCE).forEach(this::referenceItem);
                display.resolve(Platform.getSlotDisplayContext(), (DisplayContentsFactory)FluidStackContentsFactory.INSTANCE).forEach(this::referenceFluid);
            });
        }
    }

    @MustBeInvokedByOverriders
    protected void visitDisplays(RecipeDisplay recipe, Consumer<SlotDisplay> visitor) {
        visitor.accept(recipe.result());
        visitor.accept(recipe.craftingStation());
        RecipeDisplay recipeDisplay = recipe;
        Objects.requireNonNull(recipeDisplay);
        RecipeDisplay recipeDisplay2 = recipeDisplay;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class, SmithingRecipeDisplay.class, FurnaceRecipeDisplay.class, StonecutterRecipeDisplay.class}, (Object)recipeDisplay2, n)) {
            case 0: {
                ShapedCraftingRecipeDisplay craftingRecipe = (ShapedCraftingRecipeDisplay)recipeDisplay2;
                for (SlotDisplay display : craftingRecipe.ingredients()) {
                    visitor.accept(display);
                }
                break;
            }
            case 1: {
                ShapelessCraftingRecipeDisplay craftingRecipe = (ShapelessCraftingRecipeDisplay)recipeDisplay2;
                for (SlotDisplay display : craftingRecipe.ingredients()) {
                    visitor.accept(display);
                }
                break;
            }
            case 2: {
                SmithingRecipeDisplay smithingTransformRecipe = (SmithingRecipeDisplay)recipeDisplay2;
                visitor.accept(smithingTransformRecipe.base());
                visitor.accept(smithingTransformRecipe.template());
                visitor.accept(smithingTransformRecipe.addition());
                break;
            }
            case 3: {
                FurnaceRecipeDisplay furnaceRecipeDisplay = (FurnaceRecipeDisplay)recipeDisplay2;
                visitor.accept(furnaceRecipeDisplay.ingredient());
                visitor.accept(furnaceRecipeDisplay.result());
                break;
            }
            case 4: {
                StonecutterRecipeDisplay stonecutterRecipeDisplay = (StonecutterRecipeDisplay)recipeDisplay2;
                visitor.accept(stonecutterRecipeDisplay.input());
                visitor.accept(stonecutterRecipeDisplay.result());
                break;
            }
        }
    }

    private void dumpRecipes(SiteExportWriter writer) {
        for (RecipeHolder<?> holder : this.recipes) {
            ResourceKey id = holder.id();
            Recipe recipe = holder.value();
            if (recipe instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                if (craftingRecipe.isSpecial()) continue;
                writer.addRecipe(id, craftingRecipe);
                continue;
            }
            if (recipe instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
                writer.addRecipe(id, (SingleItemRecipe)cookingRecipe);
                continue;
            }
            if (recipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)recipe;
                writer.addRecipe(id, smithingTransformRecipe);
                continue;
            }
            if (recipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)recipe;
                writer.addRecipe(id, smithingTrimRecipe);
                continue;
            }
            if (recipe instanceof StonecutterRecipe) {
                StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipe;
                writer.addRecipe(id, (SingleItemRecipe)stonecutterRecipe);
                continue;
            }
            Map<String, Object> recipeFields = this.getCustomRecipeFields(id, recipe);
            if (recipeFields != null) {
                writer.addRecipe(id, recipe, recipeFields);
                continue;
            }
            LOG.warn("Unable to handle recipe {} of type {}", (Object)holder.id(), (Object)recipe.getType());
        }
    }

    @Nullable
    @ApiStatus.OverrideOnly
    protected Map<String, Object> getCustomRecipeFields(ResourceKey<Recipe<?>> id, Recipe<?> recipe) {
        return null;
    }

    @ApiStatus.OverrideOnly
    protected void postProcess(SiteExportWriter writer) {
    }

    protected String getModVersion() {
        return System.getProperty("appeng.version", "unknown");
    }

    @Override
    public Path copyResource(ResourceLocation id) {
        try {
            Path pagePath = this.getPathForWriting(id);
            byte[] bytes = this.guide.loadAsset(id);
            if (bytes == null) {
                throw new IllegalArgumentException("Couldn't find asset " + String.valueOf(id));
            }
            return CacheBusting.writeAsset(pagePath, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy resource " + String.valueOf(id), e);
        }
    }

    @Override
    public Path getPathForWriting(ResourceLocation assetId) {
        try {
            Path path = this.resolvePath(assetId);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    public ResourceLocation getPageSpecificResourceLocation(String suffix) {
        String path = this.currentPage.getId().getPath();
        int idx = path.lastIndexOf(46);
        if (idx != -1) {
            path = path.substring(0, idx);
        }
        return ResourceLocation.fromNamespaceAndPath((String)this.currentPage.getId().getNamespace(), (String)(path + "_" + suffix));
    }

    @Override
    public Path getPageSpecificPathForWriting(String suffix) {
        String pageFilename = this.currentPage.getId().getPath();
        String filename = FilenameUtils.getBaseName((String)pageFilename) + "_" + suffix;
        Path pagePath = this.resolvePath(this.currentPage.getId());
        Path path = pagePath.resolveSibling(filename);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentPageId() {
        return this.currentPage != null ? this.currentPage.getId() : null;
    }

    private void export() throws Exception {
        if (Files.isDirectory(this.outputFolder, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)this.outputFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        } else {
            Files.createDirectories(this.outputFolder, new FileAttribute[0]);
        }
        if (this.client.level == null) {
            LOG.info("Reloading datapacks to get recipes");
            GuideOnStartup.runDatapackReload();
            LOG.info("Completed datapack reload");
        }
        this.guide.getNavigationTree().getRootNodes().forEach(this::visitNavigationNodeIcons);
        SiteExportWriter indexWriter = new SiteExportWriter(this.guide);
        Iterator<ParsedGuidePage> iterator = this.guide.getPages().iterator();
        while (iterator.hasNext()) {
            ParsedGuidePage page;
            this.currentPage = page = iterator.next();
            LOG.debug("Compiling {}", (Object)page);
            GuidePage compiledPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
            this.processPage(indexWriter, page, compiledPage);
            ExportableResourceProvider.visit(compiledPage.document(), this);
        }
        this.dumpRecipes(indexWriter);
        this.processItems(this.client, indexWriter, this.outputFolder);
        this.processFluids(this.client, indexWriter, this.outputFolder);
        indexWriter.addIndex(this.guide, ItemIndex.class);
        indexWriter.addIndex(this.guide, CategoryIndex.class);
        this.postProcess(indexWriter);
        Path guideContent = this.outputFolder.resolve("guide.json.gz");
        byte[] content = indexWriter.toByteArray();
        guideContent = CacheBusting.writeAsset(guideContent, content);
        this.writeSummary(guideContent.getFileName().toString());
    }

    private void visitNavigationNodeIcons(NavigationNode navigationNode) {
        this.referenceItem(navigationNode.icon());
        navigationNode.children().forEach(this::visitNavigationNodeIcons);
    }

    private void processPage(SiteExportWriter exportWriter, ParsedGuidePage page, GuidePage compiledPage) {
        PageExportPostProcessor.postprocess(this, page, compiledPage);
        exportWriter.addPage(page);
    }

    private void writeSummary(String guideDataFilename) throws IOException {
        String modVersion = this.getModVersion();
        long generated = Instant.now().toEpochMilli();
        String gameVersion = DetectedVersion.tryDetectVersion().getName();
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFolder.resolve("index.json"), StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonWriter jsonWriter = SiteExportWriter.GSON.newJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            jsonWriter.name("format").value(1L);
            jsonWriter.name("generated").value(generated);
            jsonWriter.name("gameVersion").value(gameVersion);
            jsonWriter.name("modVersion").value(modVersion);
            jsonWriter.name("guideDataPath").value(guideDataFilename);
            jsonWriter.endObject();
        }
    }

    private Path resolvePath(ResourceLocation id) {
        return this.outputFolder.resolve(id.getNamespace() + "/" + id.getPath());
    }

    private void processItems(Minecraft client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path iconsFolder = outputFolder.resolve("!items");
        if (Files.exists(iconsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)iconsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            GuiGraphics guiGraphics = new GuiGraphics(client, client.renderBuffers().bufferSource());
            renderer.setupItemRendering();
            LOG.info("Exporting items...");
            for (Item item : this.items) {
                ItemStack stack = new ItemStack((ItemLike)item);
                String itemId = SiteExporter.getItemId(stack.getItem()).toString();
                String baseName = "!items/" + itemId.replace(':', '/');
                ItemStackRenderState renderState = new ItemStackRenderState();
                client.getItemModelResolver().appendItemLayers(renderState, stack, ItemDisplayContext.GUI, null, null, 0);
                HashSet<List<BakedQuad>> quadLists = new HashSet<List<BakedQuad>>();
                for (ItemStackRenderState.LayerRenderState layer : renderState.layers) {
                    quadLists.add(layer.prepareQuadList());
                }
                Set<TextureAtlasSprite> sprites = this.guessSprites(quadLists);
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    guiGraphics.renderItem(stack, 0, 0);
                    guiGraphics.renderItemDecorations(client.font, stack, 0, 0, "");
                }, sprites, true);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addItem(itemId, stack, absIconUrl);
            }
        }
    }

    private Set<TextureAtlasSprite> guessSprites(Collection<List<BakedQuad>> quadLists) {
        Set<TextureAtlasSprite> result = Collections.newSetFromMap(new IdentityHashMap());
        for (List<BakedQuad> quadList : quadLists) {
            for (BakedQuad quad : quadList) {
                result.add(quad.sprite());
            }
        }
        return result;
    }

    private void processFluids(Minecraft client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path fluidsFolder = outputFolder.resolve("!fluids");
        if (Files.exists(fluidsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)fluidsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            GuiGraphics guiGraphics = new GuiGraphics(client, client.renderBuffers().bufferSource());
            renderer.setupItemRendering();
            LOG.info("Exporting fluids...");
            for (Fluid fluid : this.fluids) {
                FluidStack fluidVariant = new FluidStack(fluid, 1);
                String fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid).toString();
                IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidVariant.getFluid());
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getStillTexture(fluidVariant));
                int color = props.getTintColor(fluidVariant);
                String baseName = "!fluids/" + fluidId.replace(':', '/');
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    if (sprite != null) {
                        guiGraphics.blitSprite(RenderType::guiTextured, sprite, 0, 0, 16, 16, color);
                    }
                }, sprite != null ? Set.of(sprite) : Set.of(), false);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addFluid(fluidId, fluidVariant, absIconUrl);
            }
        }
    }

    public Path renderAndWrite(OffScreenRenderer renderer, String baseName, Runnable renderRunnable, Collection<TextureAtlasSprite> sprites, boolean withAlpha) throws IOException {
        byte[] content;
        String extension;
        if (renderer.isAnimated(sprites)) {
            extension = ".webp";
            content = renderer.captureAsWebp(renderRunnable, sprites, withAlpha ? WebPExporter.Format.LOSSLESS_ALPHA : WebPExporter.Format.LOSSLESS);
        } else {
            extension = ".png";
            content = renderer.captureAsPng(renderRunnable);
        }
        Path iconPath = this.outputFolder.resolve(baseName + extension);
        Files.createDirectories(iconPath.getParent(), new FileAttribute[0]);
        return CacheBusting.writeAsset(iconPath, content);
    }

    @Override
    public String exportTexture(ResourceLocation textureId) {
        byte[] imageContent;
        String exportedPath = this.exportedTextures.get(textureId);
        if (exportedPath != null) {
            return exportedPath;
        }
        ResourceLocation id = textureId;
        if (!id.getPath().endsWith(".png")) {
            id = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getPath() + ".png"));
        }
        Path outputPath = this.getPathForWriting(id);
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(textureId);
        if (texture instanceof TextureAtlas) {
            TextureAtlas textureAtlas = (TextureAtlas)texture;
            for (SpriteContents sprite : textureAtlas.sprites) {
                if (sprite.animatedTexture == null) continue;
            }
        }
        try (NativeImage nativeImage = TextureDownloader.downloadTexture(texture.getTexture(), 0, IntUnaryOperator.identity());){
            imageContent = Platform.exportAsPng(nativeImage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            outputPath = CacheBusting.writeAsset(outputPath, imageContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to export texture " + String.valueOf(textureId), e);
        }
        exportedPath = this.getPathRelativeFromOutputFolder(outputPath);
        this.exportedTextures.put(textureId, exportedPath);
        return exportedPath;
    }

    private static ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }
}

