/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.snakeyaml.introspector;

import guideme.internal.shaded.snakeyaml.introspector.Property;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertySubstitute
extends Property {
    private static final Logger log = Logger.getLogger(PropertySubstitute.class.getPackage().getName());
    protected Class<?> targetType;
    private final String writeMethod;
    private transient Method write;
    private Field field;
    protected Class<?>[] parameters;
    private Property delegate;
    private boolean filler;

    @Override
    public Class<?>[] getActualTypeArguments() {
        if (this.parameters == null && this.delegate != null) {
            return this.delegate.getActualTypeArguments();
        }
        return this.parameters;
    }

    @Override
    public void set(Object object, Object value) throws Exception {
        if (this.write != null) {
            if (!this.filler) {
                this.write.invoke(object, value);
            } else if (value != null) {
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    for (Object val : collection) {
                        this.write.invoke(object, val);
                    }
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    for (Map.Entry entry : map.entrySet()) {
                        this.write.invoke(object, entry.getKey(), entry.getValue());
                    }
                } else if (value.getClass().isArray()) {
                    int len = Array.getLength(value);
                    for (int i = 0; i < len; ++i) {
                        this.write.invoke(object, Array.get(value, i));
                    }
                }
            }
        } else if (this.field != null) {
            this.field.set(object, value);
        } else if (this.delegate != null) {
            this.delegate.set(object, value);
        } else {
            log.warning("No setter/delegate for '" + this.getName() + "' on object " + object);
        }
    }

    private Method discoverMethod(Class<?> type, String name, Class<?> ... params) {
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!name.equals(method.getName()) || (parameterTypes = method.getParameterTypes()).length != params.length) continue;
                boolean found = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(params[i])) continue;
                    found = false;
                }
                if (!found) continue;
                method.setAccessible(true);
                return method;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Failed to find [%s(%d args)] for %s.%s", name, params.length, this.targetType.getName(), this.getName()));
        }
        return null;
    }

    @Override
    public String getName() {
        String n = super.getName();
        if (n != null) {
            return n;
        }
        return this.delegate != null ? this.delegate.getName() : null;
    }

    @Override
    public Class<?> getType() {
        Class<?> t = super.getType();
        if (t != null) {
            return t;
        }
        return this.delegate != null ? this.delegate.getType() : null;
    }

    @Override
    public boolean isWritable() {
        return this.write != null || this.field != null || this.delegate != null && this.delegate.isWritable();
    }

    public void setDelegate(Property delegate) {
        this.delegate = delegate;
        if (this.writeMethod != null && this.write == null && !this.filler) {
            this.filler = true;
            this.write = this.discoverMethod(this.targetType, this.writeMethod, this.getActualTypeArguments());
        }
    }
}

