/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.BooleanQuery;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.TermQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CommonTermsQuery
extends Query {
    protected final List<Term> terms;
    protected final float maxTermFrequency;
    protected final BooleanClause.Occur lowFreqOccur;
    protected final BooleanClause.Occur highFreqOccur;
    protected float lowFreqBoost;
    protected float highFreqBoost;
    protected float lowFreqMinNrShouldMatch;
    protected float highFreqMinNrShouldMatch;

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        IndexReader reader = indexSearcher.getIndexReader();
        if (this.terms.isEmpty()) {
            return new MatchNoDocsQuery("CommonTermsQuery with no terms");
        }
        if (this.terms.size() == 1) {
            return this.newTermQuery(this.terms.get(0), null);
        }
        List<LeafReaderContext> leaves = reader.leaves();
        int maxDoc = reader.maxDoc();
        TermStates[] contextArray = new TermStates[this.terms.size()];
        Term[] queryTerms = this.terms.toArray(new Term[0]);
        this.collectTermStates(reader, leaves, contextArray, queryTerms);
        return this.buildQuery(maxDoc, contextArray, queryTerms);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        Term[] selectedTerms = (Term[])this.terms.stream().filter(t -> visitor.acceptField(t.field())).toArray(Term[]::new);
        if (selectedTerms.length > 0) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            v.consumeTerms(this, selectedTerms);
        }
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.lowFreqMinNrShouldMatch, numOptional);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.highFreqMinNrShouldMatch, numOptional);
    }

    private final int minNrShouldMatch(float minNrShouldMatch, int numOptional) {
        if (minNrShouldMatch >= 1.0f || minNrShouldMatch == 0.0f) {
            return (int)minNrShouldMatch;
        }
        return Math.round(minNrShouldMatch * (float)numOptional);
    }

    protected Query buildQuery(int maxDoc, TermStates[] contextArray, Term[] queryTerms) {
        ArrayList<Query> lowFreqQueries = new ArrayList<Query>();
        ArrayList<Query> highFreqQueries = new ArrayList<Query>();
        for (int i = 0; i < queryTerms.length; ++i) {
            TermStates termStates = contextArray[i];
            if (termStates == null) {
                lowFreqQueries.add(this.newTermQuery(queryTerms[i], null));
                continue;
            }
            if (this.maxTermFrequency >= 1.0f && (float)termStates.docFreq() > this.maxTermFrequency || termStates.docFreq() > (int)Math.ceil(this.maxTermFrequency * (float)maxDoc)) {
                highFreqQueries.add(this.newTermQuery(queryTerms[i], termStates));
                continue;
            }
            lowFreqQueries.add(this.newTermQuery(queryTerms[i], termStates));
        }
        int numLowFreqClauses = lowFreqQueries.size();
        int numHighFreqClauses = highFreqQueries.size();
        BooleanClause.Occur lowFreqOccur = this.lowFreqOccur;
        BooleanClause.Occur highFreqOccur = this.highFreqOccur;
        int lowFreqMinShouldMatch = 0;
        int highFreqMinShouldMatch = 0;
        if (lowFreqOccur == BooleanClause.Occur.SHOULD && numLowFreqClauses > 0) {
            lowFreqMinShouldMatch = this.calcLowFreqMinimumNumberShouldMatch(numLowFreqClauses);
        }
        if (highFreqOccur == BooleanClause.Occur.SHOULD && numHighFreqClauses > 0) {
            highFreqMinShouldMatch = this.calcHighFreqMinimumNumberShouldMatch(numHighFreqClauses);
        }
        if (lowFreqQueries.isEmpty() && highFreqMinShouldMatch == 0 && highFreqOccur != BooleanClause.Occur.MUST) {
            highFreqOccur = BooleanClause.Occur.MUST;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (!lowFreqQueries.isEmpty()) {
            BooleanQuery.Builder lowFreq = new BooleanQuery.Builder();
            for (Query query : lowFreqQueries) {
                lowFreq.add(query, lowFreqOccur);
            }
            lowFreq.setMinimumNumberShouldMatch(lowFreqMinShouldMatch);
            BooleanQuery lowFreqQuery = lowFreq.build();
            builder.add(new BoostQuery(lowFreqQuery, this.lowFreqBoost), BooleanClause.Occur.MUST);
        }
        if (!highFreqQueries.isEmpty()) {
            BooleanQuery.Builder highFreq = new BooleanQuery.Builder();
            for (Query query : highFreqQueries) {
                highFreq.add(query, highFreqOccur);
            }
            highFreq.setMinimumNumberShouldMatch(highFreqMinShouldMatch);
            BooleanQuery highFreqQuery = highFreq.build();
            builder.add(new BoostQuery(highFreqQuery, this.highFreqBoost), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public void collectTermStates(IndexReader reader, List<LeafReaderContext> leaves, TermStates[] contextArray, Term[] queryTerms) throws IOException {
        TermsEnum termsEnum = null;
        for (LeafReaderContext context : leaves) {
            for (int i = 0; i < queryTerms.length; ++i) {
                Term term = queryTerms[i];
                TermStates termStates = contextArray[i];
                Terms terms = context.reader().terms(term.field());
                if (terms == null) continue;
                termsEnum = terms.iterator();
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY || !termsEnum.seekExact(term.bytes())) continue;
                if (termStates == null) {
                    contextArray[i] = new TermStates(reader.getContext(), termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                    continue;
                }
                termStates.register(termsEnum.termState(), context.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
    }

    public float getLowFreqMinimumNumberShouldMatch() {
        return this.lowFreqMinNrShouldMatch;
    }

    public float getHighFreqMinimumNumberShouldMatch() {
        return this.highFreqMinNrShouldMatch;
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getLowFreqMinimumNumberShouldMatch() > 0.0f;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.terms.size(); ++i) {
            Term t = this.terms.get(i);
            buffer.append(this.newTermQuery(t, null).toString());
            if (i == this.terms.size() - 1) continue;
            buffer.append(", ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getLowFreqMinimumNumberShouldMatch() > 0.0f || this.getHighFreqMinimumNumberShouldMatch() > 0.0f) {
            buffer.append('~');
            buffer.append("(");
            buffer.append(this.getLowFreqMinimumNumberShouldMatch());
            buffer.append(this.getHighFreqMinimumNumberShouldMatch());
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Float.floatToIntBits(this.highFreqBoost);
        result = 31 * result + Objects.hashCode((Object)this.highFreqOccur);
        result = 31 * result + Objects.hashCode((Object)this.lowFreqOccur);
        result = 31 * result + Float.floatToIntBits(this.lowFreqBoost);
        result = 31 * result + Float.floatToIntBits(this.maxTermFrequency);
        result = 31 * result + Float.floatToIntBits(this.lowFreqMinNrShouldMatch);
        result = 31 * result + Float.floatToIntBits(this.highFreqMinNrShouldMatch);
        result = 31 * result + Objects.hashCode(this.terms);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CommonTermsQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(CommonTermsQuery other) {
        return Float.floatToIntBits(this.highFreqBoost) == Float.floatToIntBits(other.highFreqBoost) && this.highFreqOccur == other.highFreqOccur && this.lowFreqOccur == other.lowFreqOccur && Float.floatToIntBits(this.lowFreqBoost) == Float.floatToIntBits(other.lowFreqBoost) && Float.floatToIntBits(this.maxTermFrequency) == Float.floatToIntBits(other.maxTermFrequency) && this.lowFreqMinNrShouldMatch == other.lowFreqMinNrShouldMatch && this.highFreqMinNrShouldMatch == other.highFreqMinNrShouldMatch && this.terms.equals(other.terms);
    }

    protected Query newTermQuery(Term term, TermStates termStates) {
        return termStates == null ? new TermQuery(term) : new TermQuery(term, termStates);
    }
}

