/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.item;

import guideme.internal.GuideME;
import guideme.internal.GuideMEProxy;
import guideme.internal.GuidebookText;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GuideItem
extends Item {
    public static final ResourceLocation ID = GuideME.makeId("guide");
    public static final ResourceLocation BASE_MODEL_ID = ID.withPrefix("item/").withSuffix("_base");
    public static final Item.Properties PROPERTIES = new Item.Properties();

    public GuideItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        Component name;
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null && (name = GuideMEProxy.instance().getGuideDisplayName(guideId)) != null) {
            return name;
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> appendLine, TooltipFlag tooltipFlag) {
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null) {
            GuideMEProxy.instance().addGuideTooltip(guideId, context, tooltipDisplay, appendLine, tooltipFlag);
        }
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId == null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)GuidebookText.ItemNoGuideId.text());
            }
            return InteractionResult.FAIL;
        }
        if (level.isClientSide && GuideMEProxy.instance().openGuide(player, guideId)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public static ResourceLocation getGuideId(ItemStack stack) {
        return (ResourceLocation)stack.get(GuideME.GUIDE_ID_COMPONENT);
    }
}

