/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.extensions;

import guideme.compiler.TagCompiler;
import guideme.compiler.tags.ATagCompiler;
import guideme.compiler.tags.BoxFlowDirection;
import guideme.compiler.tags.BoxTagCompiler;
import guideme.compiler.tags.BreakCompiler;
import guideme.compiler.tags.CategoryIndexCompiler;
import guideme.compiler.tags.ColorTagCompiler;
import guideme.compiler.tags.CommandLinkCompiler;
import guideme.compiler.tags.DivTagCompiler;
import guideme.compiler.tags.FloatingImageCompiler;
import guideme.compiler.tags.ItemGridCompiler;
import guideme.compiler.tags.ItemLinkCompiler;
import guideme.compiler.tags.RecipeCompiler;
import guideme.compiler.tags.RecipeTypeMappingSupplier;
import guideme.compiler.tags.SubPagesCompiler;
import guideme.extensions.Extension;
import guideme.extensions.ExtensionCollection;
import guideme.extensions.ExtensionPoint;
import guideme.internal.extensions.VanillaRecipes;
import guideme.scene.BlockImageTagCompiler;
import guideme.scene.ItemImageTagCompiler;
import guideme.scene.SceneTagCompiler;
import guideme.scene.annotation.BlockAnnotationElementCompiler;
import guideme.scene.annotation.BoxAnnotationElementCompiler;
import guideme.scene.annotation.DiamondAnnotationElementCompiler;
import guideme.scene.annotation.LineAnnotationElementCompiler;
import guideme.scene.element.EntityElementCompiler;
import guideme.scene.element.ImportStructureElementCompiler;
import guideme.scene.element.IsometricCameraElementCompiler;
import guideme.scene.element.SceneBlockElementCompiler;
import guideme.scene.element.SceneElementTagCompiler;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.RecipeType;

public final class DefaultExtensions {
    private static final List<Registration<?>> EXTENSIONS = List.of(new Registration<TagCompiler>(TagCompiler.EXTENSION_POINT, DefaultExtensions::tagCompilers), new Registration<SceneElementTagCompiler>(SceneElementTagCompiler.EXTENSION_POINT, DefaultExtensions::sceneElementTagCompilers), new Registration<RecipeTypeMappingSupplier>(RecipeTypeMappingSupplier.EXTENSION_POINT, DefaultExtensions::vanillaRecipeTypes));

    private DefaultExtensions() {
    }

    public static void addAll(ExtensionCollection.Builder builder, Set<ExtensionPoint<?>> disabledExtensionPoints) {
        for (Registration<?> registration : EXTENSIONS) {
            DefaultExtensions.add(builder, disabledExtensionPoints, registration);
        }
    }

    private static <T extends Extension> void add(ExtensionCollection.Builder builder, Set<ExtensionPoint<?>> disabledExtensionPoints, Registration<T> registration) {
        if (disabledExtensionPoints.contains(registration.extensionPoint)) {
            return;
        }
        for (Extension extension : registration.factory.get()) {
            builder.add(registration.extensionPoint, extension);
        }
    }

    private static List<TagCompiler> tagCompilers() {
        return List.of(new DivTagCompiler(), new ATagCompiler(), new ColorTagCompiler(), new ItemLinkCompiler(), new FloatingImageCompiler(), new BreakCompiler(), new RecipeCompiler(), new ItemGridCompiler(), new CategoryIndexCompiler(), new BlockImageTagCompiler(), new ItemImageTagCompiler(), new BoxTagCompiler(BoxFlowDirection.ROW), new BoxTagCompiler(BoxFlowDirection.COLUMN), new SceneTagCompiler(), new SubPagesCompiler(), new CommandLinkCompiler());
    }

    private static List<SceneElementTagCompiler> sceneElementTagCompilers() {
        return List.of(new EntityElementCompiler(), new SceneBlockElementCompiler(), new ImportStructureElementCompiler(), new IsometricCameraElementCompiler(), new BlockAnnotationElementCompiler(), new BoxAnnotationElementCompiler(), new LineAnnotationElementCompiler(), new DiamondAnnotationElementCompiler());
    }

    private static List<RecipeTypeMappingSupplier> vanillaRecipeTypes() {
        return List.of(mappings -> {
            mappings.addStreamFactory(RecipeType.CRAFTING, VanillaRecipes::createCrafting);
            mappings.add(RecipeType.BLASTING, VanillaRecipes::createBlasting);
            mappings.add(RecipeType.SMELTING, VanillaRecipes::createSmelting);
            mappings.add(RecipeType.SMITHING, VanillaRecipes::createSmithing);
        });
    }

    private static final class Registration<T extends Extension>
    extends Record {
        private final ExtensionPoint<T> extensionPoint;
        private final Supplier<Collection<T>> factory;

        private Registration(ExtensionPoint<T> extensionPoint, Supplier<Collection<T>> factory) {
            this.extensionPoint = extensionPoint;
            this.factory = factory;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Registration.class, "extensionPoint;factory", "extensionPoint", "factory"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Registration.class, "extensionPoint;factory", "extensionPoint", "factory"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Registration.class, "extensionPoint;factory", "extensionPoint", "factory"}, this, o);
        }
    }
}

