/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.document.interaction.ItemTooltip;
import guideme.internal.util.Platform;
import guideme.layout.LayoutContext;
import guideme.render.GuiAssets;
import guideme.render.GuiSprite;
import guideme.render.RenderContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class LytSlot
extends LytBlock
implements InteractiveElement {
    private static final int ITEM_SIZE = 16;
    private static final int PADDING = 1;
    private static final int LARGE_PADDING = 5;
    public static final int OUTER_SIZE = 18;
    public static final int OUTER_SIZE_LARGE = 26;
    private static final int CYCLE_TIME = 2000;
    private boolean largeSlot;
    private final List<ItemStack> stacks;

    public LytSlot(SlotDisplay display) {
        this.stacks = display.resolveForStacks(Platform.getSlotDisplayContext());
    }

    public LytSlot(Ingredient ingredient) {
        this.stacks = ingredient.items().map(Holder::value).map(Item::getDefaultInstance).toList();
    }

    public LytSlot(Optional<Ingredient> ingredient) {
        this.stacks = ingredient.isPresent() ? ingredient.get().items().map(Holder::value).map(Item::getDefaultInstance).toList() : List.of();
    }

    public LytSlot(ItemStack stack) {
        this.stacks = stack.isEmpty() ? List.of() : List.of(stack);
    }

    public boolean isLargeSlot() {
        return this.largeSlot;
    }

    public void setLargeSlot(boolean largeSlot) {
        this.largeSlot = largeSlot;
    }

    @Override
    protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
        if (this.largeSlot) {
            return new LytRect(x, y, 26, 26);
        }
        return new LytRect(x, y, 18, 18);
    }

    @Override
    protected void onLayoutMoved(int deltaX, int deltaY) {
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
    }

    @Override
    public void render(RenderContext context) {
        int x = this.bounds.x();
        int y = this.bounds.y();
        GuiSprite texture = this.largeSlot ? GuiAssets.LARGE_SLOT : GuiAssets.SLOT;
        context.fillIcon(this.bounds, texture);
        int padding = this.largeSlot ? 5 : 1;
        ItemStack stack = this.getDisplayedStack();
        if (!stack.isEmpty()) {
            context.renderItem(stack, x + padding, y + padding, 1, 16.0f, 16.0f);
        }
    }

    @Override
    public Optional<GuideTooltip> getTooltip(float x, float y) {
        ItemStack stack = this.getDisplayedStack();
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ItemTooltip(stack));
    }

    private ItemStack getDisplayedStack() {
        if (this.stacks.isEmpty()) {
            return ItemStack.EMPTY;
        }
        long cycle = System.nanoTime() / TimeUnit.MILLISECONDS.toNanos(2000L);
        return this.stacks.get((int)(cycle % (long)this.stacks.size()));
    }
}

