/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.level;

import guideme.internal.GuideME;
import guideme.internal.util.Platform;
import guideme.scene.level.GuidebookChunkSource;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class GuidebookLevel
extends Level {
    private static final ResourceKey<Level> LEVEL_ID = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)GuideME.makeId("guidebook"));
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager(Entity.class, (LevelCallback)new EntityCallbacks());
    private final ChunkSource chunkSource = new GuidebookChunkSource(this);
    private final Holder<Biome> biome;
    private final RegistryAccess registryAccess;
    private final LongSet filledBlocks = new LongOpenHashSet();
    private final LongSet litSections = new LongOpenHashSet();
    private final DataLayer defaultDataLayer;
    private final TickRateManager tickRateManager = new TickRateManager();
    private final ClientLevel.ClientLevelData clientLevelData;
    private final DeltaTracker.Timer tracker = new DeltaTracker.Timer(20.0f, 0L, def -> def);
    private float partialTick;

    public GuidebookLevel() {
        this(Platform.getClientRegistryAccess());
    }

    public GuidebookLevel(RegistryAccess registryAccess) {
        this(GuidebookLevel.createLevelData(), registryAccess);
    }

    private GuidebookLevel(ClientLevel.ClientLevelData levelData, RegistryAccess registryAccess) {
        super((WritableLevelData)levelData, LEVEL_ID, registryAccess, (Holder)registryAccess.lookupOrThrow(Registries.DIMENSION_TYPE).getOrThrow(BuiltinDimensionTypes.OVERWORLD), true, false, 0L, 1000000);
        this.clientLevelData = levelData;
        this.registryAccess = registryAccess;
        this.biome = registryAccess.lookupOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS);
        byte[] nibbles = new byte[2048];
        Arrays.fill(nibbles, (byte)-1);
        this.defaultDataLayer = new DataLayer(nibbles);
    }

    public Bounds getBounds() {
        if (this.filledBlocks.isEmpty()) {
            return new Bounds(BlockPos.ZERO, BlockPos.ZERO);
        }
        BlockPos.MutableBlockPos min = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos.MutableBlockPos max = new BlockPos.MutableBlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        BlockPos.MutableBlockPos cur = new BlockPos.MutableBlockPos();
        this.filledBlocks.forEach(packedPos -> {
            cur.set(packedPos);
            min.setX(Math.min(min.getX(), cur.getX()));
            min.setY(Math.min(min.getY(), cur.getY()));
            min.setZ(Math.min(min.getZ(), cur.getZ()));
            max.setX(Math.max(max.getX(), cur.getX() + 1));
            max.setY(Math.max(max.getY(), cur.getY() + 1));
            max.setZ(Math.max(max.getZ(), cur.getZ() + 1));
        });
        for (Entity entity : this.getEntitiesForRendering()) {
            AABB bounds = entity.getBoundingBox();
            min.setX(Math.min(min.getX(), (int)bounds.minX));
            min.setY(Math.min(min.getY(), (int)bounds.minY));
            min.setZ(Math.min(min.getZ(), (int)bounds.minZ));
            max.setX(Math.max(max.getX(), (int)Math.ceil(bounds.maxX)));
            max.setY(Math.max(max.getY(), (int)Math.ceil(bounds.maxY)));
            max.setZ(Math.max(max.getZ(), (int)Math.ceil(bounds.maxZ)));
        }
        return new Bounds((BlockPos)min, (BlockPos)max);
    }

    public boolean isFilledBlock(BlockPos blockPos) {
        return this.filledBlocks.contains(blockPos.asLong());
    }

    void removeFilledBlock(BlockPos pos) {
        this.filledBlocks.remove(pos.asLong());
    }

    void addFilledBlock(BlockPos pos) {
        this.filledBlocks.add(pos.asLong());
    }

    public void prepareLighting(BlockPos pos) {
        ChunkPos minChunk = new ChunkPos(pos.offset(-1, -1, -1));
        ChunkPos maxChunk = new ChunkPos(pos.offset(1, 1, 1));
        ChunkPos.rangeClosed((ChunkPos)minChunk, (ChunkPos)maxChunk).forEach(chunkPos -> {
            if (this.litSections.add(chunkPos.toLong())) {
                LevelLightEngine lightEngine = this.getLightEngine();
                for (int i = 0; i < this.getSectionsCount(); ++i) {
                    int y = this.getSectionYFromSectionIndex(i);
                    SectionPos sectionPos = SectionPos.of((ChunkPos)chunkPos, (int)y);
                    lightEngine.updateSectionStatus(sectionPos, false);
                    lightEngine.queueSectionData(LightLayer.BLOCK, sectionPos, this.defaultDataLayer);
                    lightEngine.queueSectionData(LightLayer.SKY, sectionPos, this.defaultDataLayer);
                }
                lightEngine.setLightEnabled(chunkPos, true);
                lightEngine.propagateLightSources(chunkPos);
                lightEngine.retainData(chunkPos, false);
            }
        });
    }

    private static ClientLevel.ClientLevelData createLevelData() {
        ClientLevel.ClientLevelData levelData = new ClientLevel.ClientLevelData(Difficulty.PEACEFUL, false, false);
        levelData.setDayTime(6000L);
        return levelData;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public void onRenderFrame() {
        int ticksElapsed = this.tracker.advanceTime(Util.getMillis(), true);
        if (ticksElapsed > 0) {
            this.clientLevelData.setGameTime(this.clientLevelData.getGameTime() + (long)ticksElapsed);
        }
        this.partialTick = this.tracker.getGameTimeDeltaPartialTick(false);
    }

    public boolean hasFilledBlocks() {
        return !this.filledBlocks.isEmpty();
    }

    public Stream<BlockPos> getFilledBlocks() {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        return this.filledBlocks.longStream().sequential().mapToObj(pos -> {
            mutablePos.set(pos);
            return mutablePos;
        });
    }

    public Set<BlockEntity> getBlockEntities() {
        return this.getFilledBlocks().map(arg_0 -> ((GuidebookLevel)this).getBlockEntity(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return this.entityStorage.getEntityGetter();
    }

    public Iterable<Entity> getEntitiesForRendering() {
        return this.entityStorage.getEntityGetter().getAll();
    }

    public void addEntity(Entity entity) {
        this.removeEntity(entity.getId(), Entity.RemovalReason.DISCARDED);
        this.entityStorage.addEntity((EntityAccess)entity);
        entity.onAddedToLevel();
        this.prepareLighting(entity.getOnPos());
    }

    public void removeEntity(int entityId, Entity.RemovalReason reason) {
        Entity entity = (Entity)this.getEntities().get(entityId);
        if (entity != null) {
            entity.setRemoved(reason);
            entity.onClientRemoval();
        }
    }

    @Nullable
    public Entity getEntity(int id) {
        return (Entity)this.getEntities().get(id);
    }

    public TickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public void sendBlockUpdated(BlockPos pos, BlockState oldState, BlockState newState, int flags) {
    }

    public void playSeededSound(@Nullable Entity p_394382_, double p_220364_, double p_220365_, double p_220366_, Holder<SoundEvent> p_394088_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
    }

    public void playSeededSound(@Nullable Entity p_394455_, Entity p_393481_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
    }

    public String gatherChunkSourceStats() {
        return "";
    }

    @Nullable
    public MapItemSavedData getMapData(MapId mapId) {
        return null;
    }

    public void destroyBlockProgress(int breakerId, BlockPos pos, int progress) {
    }

    public Scoreboard getScoreboard() {
        return new Scoreboard();
    }

    public RecipeAccess recipeAccess() {
        if (Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.recipeAccess();
        }
        return new RecipeAccess(this){

            public RecipePropertySet propertySet(ResourceKey<RecipePropertySet> propertySet) {
                return RecipePropertySet.EMPTY;
            }

            public SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecutterRecipes() {
                return SelectableRecipe.SingleInputSet.empty();
            }
        };
    }

    public FuelValues fuelValues() {
        return Platform.fuelValues();
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public ChunkSource getChunkSource() {
        return this.chunkSource;
    }

    public void levelEvent(@Nullable Entity player, int type, BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> gameEvent, Vec3 vec3, GameEvent.Context context) {
    }

    public float getShade(Direction direction, boolean shade) {
        if (!shade) {
            return 1.0f;
        }
        return switch (direction) {
            case Direction.DOWN -> 0.5f;
            case Direction.NORTH, Direction.SOUTH -> 0.8f;
            case Direction.WEST, Direction.EAST -> 0.6f;
            default -> 1.0f;
        };
    }

    public List<? extends Player> players() {
        return List.of();
    }

    public Holder<Biome> getUncachedNoiseBiome(int i, int j, int k) {
        return this.biome;
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public PotionBrewing potionBrewing() {
        throw new UnsupportedOperationException();
    }

    public void setDayTimeFraction(float v) {
        throw new UnsupportedOperationException();
    }

    public float getDayTimeFraction() {
        throw new UnsupportedOperationException();
    }

    public float getDayTimePerTick() {
        throw new UnsupportedOperationException();
    }

    public void setDayTimePerTick(float v) {
        throw new UnsupportedOperationException();
    }

    public FeatureFlagSet enabledFeatures() {
        return FeatureFlags.DEFAULT_FLAGS;
    }

    public void explode(@Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, ParticleOptions smallExplosionParticles, ParticleOptions largeExplosionParticles, Holder<SoundEvent> explosionSound) {
    }

    public Collection<PartEntity<?>> dragonParts() {
        return List.of();
    }

    public int getSeaLevel() {
        return 0;
    }

    private static class EntityCallbacks
    implements LevelCallback<Entity> {
        private EntityCallbacks() {
        }

        public void onCreated(Entity entity) {
        }

        public void onDestroyed(Entity entity) {
        }

        public void onTickingStart(Entity entity) {
        }

        public void onTickingEnd(Entity entity) {
        }

        public void onTrackingStart(Entity entity) {
        }

        public void onTrackingEnd(Entity entity) {
        }

        public void onSectionChange(Entity object) {
        }
    }

    public record Bounds(BlockPos min, BlockPos max) {
    }
}

