/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;

public final class ThematicBreak {
    public static final Construct thematicBreak = new Construct();

    static {
        ThematicBreak.thematicBreak.name = "thematicBreak";
        ThematicBreak.thematicBreak.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private int size;
        int marker;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 42 || code == 45 || code == 95, "expected `*`, `-`, or `_`");
            this.effects.enter("thematicBreak");
            this.marker = code;
            return this.atBreak(code);
        }

        private State atBreak(int code) {
            if (code == this.marker) {
                this.effects.enter("thematicBreakSequence");
                return this.sequence(code);
            }
            if (CharUtil.markdownSpace(code)) {
                return FactorySpace.create(this.effects, this::atBreak, "whitespace").step(code);
            }
            if (this.size < 3 || code != Integer.MIN_VALUE && !CharUtil.markdownLineEnding(code)) {
                return this.nok.step(code);
            }
            this.effects.exit("thematicBreak");
            return this.ok.step(code);
        }

        private State sequence(int code) {
            if (code == this.marker) {
                this.effects.consume(code);
                ++this.size;
                return this::sequence;
            }
            this.effects.exit("thematicBreakSequence");
            return this.atBreak(code);
        }
    }
}

