/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.commonmark.Subtokenize;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.List;
import java.util.Objects;

public final class Content {
    public static final Construct content = new Construct();
    public static final Construct continuationConstruct;

    private static List<Tokenizer.Event> resolveContent(List<Tokenizer.Event> events, TokenizeContext context) {
        Subtokenize.subtokenize(events);
        return events;
    }

    static {
        Content.content.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        Content.content.resolve = Content::resolveContent;
        continuationConstruct = new Construct();
        Content.continuationConstruct.tokenize = (context, effects, ok, nok) -> new ContinuationStateMachine(context, effects, ok, nok)::startLookahead;
        Content.continuationConstruct.partial = true;
    }

    private static class ContinuationStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public ContinuationStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State startLookahead(int code) {
            Assert.check(CharUtil.markdownLineEnding(code), "expected a line ending");
            this.effects.exit("chunkContent");
            this.effects.enter("lineEnding");
            this.effects.consume(code);
            this.effects.exit("lineEnding");
            return FactorySpace.create(this.effects, this::prefixed, "linePrefix");
        }

        private State prefixed(int code) {
            if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                return this.nok.step(code);
            }
            Tokenizer.Event tail = this.context.getLastEvent();
            if (!this.context.getParser().constructs.nullDisable.contains("codeIndented") && tail != null && Objects.equals(tail.token().type, "linePrefix") && tail.context().sliceSerialize(tail.token(), true).length() >= 4) {
                return this.ok.step(code);
            }
            return this.effects.interrupt.hook(this.context.getParser().constructs.flow, this.nok, this.ok).step(code);
        }
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        Token previous;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code != Integer.MIN_VALUE && !CharUtil.markdownLineEnding(code), "expected no eof or eol");
            this.effects.enter("content");
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.CONTENT;
            this.previous = this.effects.enter("chunkContent", tokenFields);
            return this.data(code);
        }

        private State data(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.contentEnd(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                return this.effects.check.hook(continuationConstruct, this::contentContinue, this::contentEnd).step(code);
            }
            this.effects.consume(code);
            return this::data;
        }

        private State contentEnd(int code) {
            this.effects.exit("chunkContent");
            this.effects.exit("content");
            return this.ok.step(code);
        }

        private State contentContinue(int code) {
            Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
            this.effects.consume(code);
            this.effects.exit("chunkContent");
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.CONTENT;
            tokenFields.previous = this.previous;
            this.previous = this.previous.next = this.effects.enter("chunkContent", tokenFields);
            return this::data;
        }
    }
}

