/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.util;

import com.mojang.blaze3d.platform.NativeImage;
import guideme.internal.GuideMEClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger LOG = LoggerFactory.getLogger(Platform.class);
    public static RecipeManager fallbackClientRecipeManager;
    public static RegistryAccess fallbackClientRegistryAccess;

    public static RegistryAccess getClientRegistryAccess() {
        if (Minecraft.getInstance() != null && Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.registryAccess();
        }
        return Objects.requireNonNull(fallbackClientRegistryAccess);
    }

    public static Component getFluidDisplayName(Fluid fluid) {
        FluidStack fluidStack = new FluidStack(fluid, 1);
        return fluidStack.getHoverName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] exportAsPng(NativeImage nativeImage) throws IOException {
        Path tempFile = null;
        try {
            tempFile = Files.createTempFile("siteexport", ".png", new FileAttribute[0]);
            nativeImage.writeToFile(tempFile);
            byte[] byArray = Files.readAllBytes(tempFile);
            return byArray;
        }
        finally {
            if (tempFile != null) {
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException e) {
                    LOG.error("Failed to delete temporary file {}", (Object)tempFile, (Object)e);
                }
            }
        }
    }

    public static ContextMap getSlotDisplayContext() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return SlotDisplayContext.fromLevel((Level)level);
        }
        return new ContextMap.Builder().withParameter(SlotDisplayContext.FUEL_VALUES, (Object)Platform.fuelValues()).withParameter(SlotDisplayContext.REGISTRIES, (Object)Platform.getClientRegistryAccess()).create(SlotDisplayContext.CONTEXT);
    }

    public static FuelValues fuelValues() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return Platform.fuelValues();
        }
        return FuelValues.vanillaBurnTimes((HolderLookup.Provider)Platform.getClientRegistryAccess(), (FeatureFlagSet)FeatureFlags.VANILLA_SET);
    }

    public static RecipeMap getRecipeMap() {
        return GuideMEClient.instance().getRecipeMap();
    }

    public static boolean isRecipeTypeAvailable(RecipeType<?> recipeType) {
        return GuideMEClient.instance().isRecipeTypeAvailable(recipeType);
    }

    public static boolean recipeHasResult(Recipe<?> recipe, Item item) {
        for (RecipeDisplay recipeDisplay : recipe.display()) {
            boolean hasResult = recipeDisplay.result().resolve(Platform.getSlotDisplayContext(), (DisplayContentsFactory)SlotDisplay.ItemStackContentsFactory.INSTANCE).anyMatch(is -> is.is(item));
            if (!hasResult) continue;
            return true;
        }
        return false;
    }
}

