/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.snakeyaml.nodes;

import guideme.internal.shaded.snakeyaml.DumperOptions;
import guideme.internal.shaded.snakeyaml.error.Mark;
import guideme.internal.shaded.snakeyaml.nodes.CollectionNode;
import guideme.internal.shaded.snakeyaml.nodes.Node;
import guideme.internal.shaded.snakeyaml.nodes.NodeId;
import guideme.internal.shaded.snakeyaml.nodes.Tag;
import java.util.List;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, Mark startMark, Mark endMark, DumperOptions.FlowStyle flowStyle) {
        super(tag, startMark, endMark, flowStyle);
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = value;
        this.resolved = resolved;
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.sequence;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public void setListType(Class<? extends Object> listType) {
        for (Node node : this.value) {
            node.setType(listType);
        }
    }

    public String toString() {
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", value=" + this.getValue() + ")>";
    }
}

