/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.util.BytesRef;
import java.util.Arrays;

public final class UnicodeUtil {
    public static final BytesRef BIG_TERM = new BytesRef(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    static final int[] utf8CodeLength;

    private UnicodeUtil() {
    }

    public static int UTF16toUTF8(char[] source, int offset, int length, byte[] out) {
        int upto = 0;
        int i = offset;
        int end = offset + length;
        while (i < end) {
            int utf32;
            char code;
            if ((code = source[i++]) < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end && (utf32 = source[i]) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        return upto;
    }

    public static int UTF16toUTF8(CharSequence s, int offset, int length, byte[] out) {
        return UnicodeUtil.UTF16toUTF8(s, offset, length, out, 0);
    }

    public static int UTF16toUTF8(CharSequence s, int offset, int length, byte[] out, int outOffset) {
        int end = offset + length;
        int upto = outOffset;
        for (int i = offset; i < end; ++i) {
            int utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                out[upto++] = (byte)code;
                continue;
            }
            if (code < '\u0800') {
                out[upto++] = (byte)(0xC0 | code >> 6);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                out[upto++] = (byte)(0xE0 | code >> 12);
                out[upto++] = (byte)(0x80 | code >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | code & 0x3F);
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= 56320 && utf32 <= 57343) {
                utf32 = (code << 10) + utf32 + -56613888;
                ++i;
                out[upto++] = (byte)(0xF0 | utf32 >> 18);
                out[upto++] = (byte)(0x80 | utf32 >> 12 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 >> 6 & 0x3F);
                out[upto++] = (byte)(0x80 | utf32 & 0x3F);
                continue;
            }
            out[upto++] = -17;
            out[upto++] = -65;
            out[upto++] = -67;
        }
        return upto;
    }

    public static int calcUTF16toUTF8Length(CharSequence s, int offset, int len) {
        int end = offset + len;
        int res = 0;
        for (int i = offset; i < end; ++i) {
            char utf32;
            char code = s.charAt(i);
            if (code < '\u0080') {
                ++res;
                continue;
            }
            if (code < '\u0800') {
                res += 2;
                continue;
            }
            if (code < '\ud800' || code > '\udfff') {
                res += 3;
                continue;
            }
            if (code < '\udc00' && i < end - 1 && (utf32 = s.charAt(i + 1)) >= '\udc00' && utf32 <= '\udfff') {
                ++i;
                res += 4;
                continue;
            }
            res += 3;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int codePointCount(BytesRef utf8) {
        int pos = utf8.offset;
        int limit = pos + utf8.length;
        byte[] bytes = utf8.bytes;
        int codePointCount = 0;
        while (pos < limit) {
            int v = bytes[pos] & 0xFF;
            if (v < 128) {
                ++pos;
            } else {
                if (v < 192) throw new IllegalArgumentException();
                if (v < 224) {
                    pos += 2;
                } else if (v < 240) {
                    pos += 3;
                } else {
                    if (v >= 248) throw new IllegalArgumentException();
                    pos += 4;
                }
            }
            ++codePointCount;
        }
        if (pos <= limit) return codePointCount;
        throw new IllegalArgumentException();
    }

    public static int UTF8toUTF32(BytesRef utf8, int[] ints) {
        int utf32Count = 0;
        byte[] bytes = utf8.bytes;
        int utf8Limit = utf8.offset + utf8.length;
        UTF8CodePoint reuse = null;
        for (int utf8Upto = utf8.offset; utf8Upto < utf8Limit; utf8Upto += reuse.numBytes) {
            reuse = UnicodeUtil.codePointAt(bytes, utf8Upto, reuse);
            ints[utf32Count++] = reuse.codePoint;
        }
        return utf32Count;
    }

    public static UTF8CodePoint codePointAt(byte[] utf8, int pos, UTF8CodePoint reuse) {
        int v;
        int numBytes;
        if (reuse == null) {
            reuse = new UTF8CodePoint();
        }
        int leadByte = utf8[pos] & 0xFF;
        reuse.numBytes = numBytes = utf8CodeLength[leadByte];
        switch (numBytes) {
            case 1: {
                reuse.codePoint = leadByte;
                return reuse;
            }
            case 2: {
                v = leadByte & 0x1F;
                break;
            }
            case 3: {
                v = leadByte & 0xF;
                break;
            }
            case 4: {
                v = leadByte & 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid UTF8 header byte: 0x" + Integer.toHexString(leadByte));
            }
        }
        int limit = pos + numBytes;
        ++pos;
        while (pos < limit) {
            v = v << 6 | utf8[pos++] & 0x3F;
        }
        reuse.codePoint = v;
        return reuse;
    }

    public static String newString(int[] codePoints, int offset, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        char[] chars = new char[count];
        int w = 0;
        int e = offset + count;
        block2: for (int r = offset; r < e; ++r) {
            int cp = codePoints[r];
            if (cp < 0 || cp > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (cp < 65536) {
                        chars[w] = (char)cp;
                        ++w;
                        continue block2;
                    }
                    chars[w] = (char)(55232 + (cp >> 10));
                    chars[w + 1] = (char)(56320 + (cp & 0x3FF));
                    w += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException ex) {
                    int newlen = (int)Math.ceil((double)codePoints.length * (double)(w + 2) / (double)(r - offset + 1));
                    char[] temp = new char[newlen];
                    System.arraycopy(chars, 0, temp, 0, w);
                    chars = temp;
                    continue;
                }
                break;
            }
        }
        return new String(chars, 0, w);
    }

    public static int UTF8toUTF16(byte[] utf8, int offset, int length, char[] out) {
        int out_offset = 0;
        int limit = offset + length;
        while (offset < limit) {
            int b;
            if ((b = utf8[offset++] & 0xFF) < 192) {
                assert (b < 128);
                out[out_offset++] = (char)b;
                continue;
            }
            if (b < 224) {
                out[out_offset++] = (char)(((b & 0x1F) << 6) + (utf8[offset++] & 0x3F));
                continue;
            }
            if (b < 240) {
                out[out_offset++] = (char)(((b & 0xF) << 12) + ((utf8[offset] & 0x3F) << 6) + (utf8[offset + 1] & 0x3F));
                offset += 2;
                continue;
            }
            assert (b < 248) : "b = 0x" + Integer.toHexString(b);
            int ch = ((b & 7) << 18) + ((utf8[offset] & 0x3F) << 12) + ((utf8[offset + 1] & 0x3F) << 6) + (utf8[offset + 2] & 0x3F);
            offset += 3;
            if ((long)ch < 65535L) {
                out[out_offset++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[out_offset++] = (char)((chHalf >> 10) + 55296);
            out[out_offset++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        return out_offset;
    }

    public static int maxUTF8Length(int utf16Length) {
        return Math.multiplyExact(utf16Length, 3);
    }

    public static int UTF8toUTF16(BytesRef bytesRef, char[] chars) {
        return UnicodeUtil.UTF8toUTF16(bytesRef.bytes, bytesRef.offset, bytesRef.length, chars);
    }

    static {
        int v = Integer.MIN_VALUE;
        utf8CodeLength = Arrays.stream(new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {4, 4, 4, 4, 4, 4, 4, 4}}).flatMapToInt(Arrays::stream).toArray();
    }

    public static final class UTF8CodePoint {
        public int codePoint;
        public int numBytes;
    }
}

