/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class BitUtil {
    public static final ByteOrder NATIVE_BYTE_ORDER = BitUtil.getNativeByteOrder();
    public static final VarHandle VH_LE_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_LE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);
    public static final VarHandle VH_NATIVE_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, NATIVE_BYTE_ORDER);
    public static final VarHandle VH_NATIVE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, NATIVE_BYTE_ORDER);
    public static final VarHandle VH_NATIVE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, NATIVE_BYTE_ORDER);
    public static final VarHandle VH_NATIVE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, NATIVE_BYTE_ORDER);
    public static final VarHandle VH_NATIVE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, NATIVE_BYTE_ORDER);
    @Deprecated
    public static final VarHandle VH_BE_SHORT = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_INT = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_FLOAT = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.BIG_ENDIAN);
    @Deprecated
    public static final VarHandle VH_BE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.BIG_ENDIAN);

    private static ByteOrder getNativeByteOrder() {
        try {
            String prop = System.getProperty("tests.seed");
            if (prop != null) {
                return prop.hashCode() % 2 == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ByteOrder.nativeOrder();
    }

    public static int nextHighestPowerOfTwo(int v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    public static long nextHighestPowerOfTwo(long v) {
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return ++v;
    }

    public static int zigZagEncode(int i) {
        return i >> 31 ^ i << 1;
    }

    public static long zigZagEncode(long l) {
        return l >> 63 ^ l << 1;
    }

    public static int zigZagDecode(int i) {
        return i >>> 1 ^ -(i & 1);
    }

    public static long zigZagDecode(long l) {
        return l >>> 1 ^ -(l & 1L);
    }
}

