/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public int length() {
        return this.limit;
    }

    @Override
    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos + count);
    }

    @Override
    public short readShort() {
        try {
            short s = BitUtil.VH_LE_SHORT.get(this.bytes, this.pos);
            return s;
        }
        finally {
            this.pos += 2;
        }
    }

    @Override
    public int readInt() {
        try {
            int n = BitUtil.VH_LE_INT.get(this.bytes, this.pos);
            return n;
        }
        finally {
            this.pos += 4;
        }
    }

    @Override
    public long readLong() {
        try {
            long l = BitUtil.VH_LE_LONG.get(this.bytes, this.pos);
            return l;
        }
        finally {
            this.pos += 8;
        }
    }

    @Override
    public int readVInt() {
        try {
            return super.readVInt();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayDataInput#readByte should not throw IOException");
        }
    }

    @Override
    public long readVLong() {
        try {
            return super.readVLong();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"ByteArrayDataInput#readByte should not throw IOException");
        }
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset, len);
        this.pos += len;
    }
}

