/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Scorable;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerUtil;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

final class BlockMaxConjunctionScorer
extends Scorer {
    final Scorer[] scorers;
    final Scorable[] scorables;
    final DocIdSetIterator[] approximations;
    final TwoPhaseIterator[] twoPhases;
    float minScore;

    BlockMaxConjunctionScorer(Collection<Scorer> scorersList) throws IOException {
        this.scorers = scorersList.toArray(new Scorer[scorersList.size()]);
        Arrays.sort(this.scorers, Comparator.comparingLong(s -> s.iterator().cost()));
        this.scorables = (Scorable[])Arrays.stream(this.scorers).map(ScorerUtil::likelyTermScorer).toArray(Scorable[]::new);
        this.approximations = new DocIdSetIterator[this.scorers.length];
        ArrayList<TwoPhaseIterator> twoPhaseList = new ArrayList<TwoPhaseIterator>();
        for (int i = 0; i < this.scorers.length; ++i) {
            Scorer scorer = this.scorers[i];
            TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
            if (twoPhase != null) {
                twoPhaseList.add(twoPhase);
                this.approximations[i] = twoPhase.approximation();
            } else {
                this.approximations[i] = scorer.iterator();
            }
            this.approximations[i] = ScorerUtil.likelyImpactsEnum(this.approximations[i]);
            scorer.advanceShallow(0);
        }
        this.twoPhases = twoPhaseList.toArray(new TwoPhaseIterator[twoPhaseList.size()]);
        Arrays.sort(this.twoPhases, Comparator.comparingDouble(TwoPhaseIterator::matchCost));
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        if (this.twoPhases.length == 0) {
            return null;
        }
        final float matchCost = (float)Arrays.stream(this.twoPhases).mapToDouble(TwoPhaseIterator::matchCost).sum();
        DocIdSetIterator approx = this.approximation();
        return new TwoPhaseIterator(approx){

            @Override
            public boolean matches() throws IOException {
                for (TwoPhaseIterator twoPhase : BlockMaxConjunctionScorer.this.twoPhases) {
                    assert (twoPhase.approximation().docID() == BlockMaxConjunctionScorer.this.docID());
                    if (twoPhase.matches()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public float matchCost() {
                return matchCost;
            }
        };
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.twoPhases.length == 0 ? this.approximation() : TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    private DocIdSetIterator approximation() {
        final DocIdSetIterator lead = this.approximations[0];
        return new DocIdSetIterator(){
            float maxScore;
            int upTo = -1;

            @Override
            public int docID() {
                return lead.docID();
            }

            @Override
            public long cost() {
                return lead.cost();
            }

            private void moveToNextBlock(int target) throws IOException {
                if (BlockMaxConjunctionScorer.this.minScore == 0.0f) {
                    this.upTo = target;
                    this.maxScore = Float.POSITIVE_INFINITY;
                } else {
                    this.upTo = BlockMaxConjunctionScorer.this.advanceShallow(target);
                    this.maxScore = BlockMaxConjunctionScorer.this.getMaxScore(this.upTo);
                }
            }

            private int advanceTarget(int target) throws IOException {
                if (target > this.upTo) {
                    this.moveToNextBlock(target);
                }
                while (true) {
                    assert (this.upTo >= target);
                    if (this.maxScore >= BlockMaxConjunctionScorer.this.minScore) {
                        return target;
                    }
                    if (this.upTo == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    target = this.upTo + 1;
                    this.moveToNextBlock(target);
                }
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                return this.doNext(lead.advance(this.advanceTarget(target)));
            }

            private int doNext(int doc) throws IOException {
                block0: while (true) {
                    int nextTarget;
                    assert (doc == lead.docID());
                    if (doc == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (doc > this.upTo && (nextTarget = this.advanceTarget(doc)) != doc) {
                        doc = lead.advance(nextTarget);
                        continue;
                    }
                    assert (doc <= this.upTo);
                    for (int i = 1; i < BlockMaxConjunctionScorer.this.approximations.length; ++i) {
                        int next;
                        DocIdSetIterator other = BlockMaxConjunctionScorer.this.approximations[i];
                        if (other.docID() < doc && (next = other.advance(doc)) > doc) {
                            doc = lead.advance(this.advanceTarget(next));
                            continue block0;
                        }
                        assert (other.docID() == doc);
                    }
                    break;
                }
                return doc;
            }
        };
    }

    @Override
    public int docID() {
        return this.scorers[0].docID();
    }

    @Override
    public float score() throws IOException {
        double score = 0.0;
        for (Scorable scorer : this.scorables) {
            score += (double)scorer.score();
        }
        return (float)score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int result = this.scorers[0].advanceShallow(target);
        for (int i = 1; i < this.scorers.length; ++i) {
            this.scorers[i].advanceShallow(target);
        }
        return result;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.getMaxScore(upTo);
        }
        return (float)sum;
    }

    @Override
    public void setMinCompetitiveScore(float score) throws IOException {
        this.minScore = score;
    }
}

