/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.BufferAllocationException;
import guideme.internal.shaded.lucene.internal.hppc.HashContainers;
import guideme.internal.shaded.lucene.internal.hppc.ObjectCursor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Iterator;
import java.util.Objects;

public class LongObjectHashMap<VType>
implements Accountable,
Cloneable,
Iterable<LongObjectCursor<VType>> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongObjectHashMap.class);
    public long[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public LongObjectHashMap() {
        this(4);
    }

    public LongObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public VType put(long key, VType value) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0L) {
            Object previousValue = this.hasEmptyKey ? this.values[mask + 1] : null;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    public VType remove(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            if (!this.hasEmptyKey) {
                return null;
            }
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public VType get(long key) {
        long existing;
        if (key == 0L) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongObjectCursor<?> c : other) {
            long key = c.key;
            if (this.containsKey(key) && Objects.equals(c.value, this.get(key))) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + this.sizeOfValues();
    }

    private long sizeOfValues() {
        long size = RamUsageEstimator.shallowSizeOf(this.values);
        for (ObjectCursor value : this.values()) {
            size += RamUsageEstimator.sizeOfObject(value);
        }
        return size;
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public LongObjectHashMap<VType> clone() {
        try {
            LongObjectHashMap cloned = (LongObjectHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            long existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        long[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values[gapSlot] = null;
        --this.assigned;
    }

    public static final class LongObjectCursor<VType> {
        public int index;
        public long key;
        public VType value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + String.valueOf(this.value) + "]";
        }
    }

    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        private final LongObjectCursor<VType> cursor = new LongObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongObjectHashMap.this.mask;
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            int mask = LongObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongObjectHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = LongObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0L;
                this.cursor.value = LongObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (LongObjectCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>> {
        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongObjectHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int mask = LongObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongObjectHashMap.this.keys[this.slot] == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.value = LongObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = LongObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

