/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.StandardDirectoryReader;
import guideme.internal.shaded.lucene.store.Directory;

public abstract class IndexCommit
implements Comparable<IndexCommit> {
    public abstract String getSegmentsFileName();

    public abstract Directory getDirectory();

    public abstract void delete();

    protected IndexCommit() {
    }

    public boolean equals(Object other) {
        if (other instanceof IndexCommit) {
            IndexCommit otherCommit = (IndexCommit)other;
            return otherCommit.getDirectory() == this.getDirectory() && otherCommit.getGeneration() == this.getGeneration();
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode() + Long.valueOf(this.getGeneration()).hashCode();
    }

    public abstract long getGeneration();

    @Override
    public int compareTo(IndexCommit commit) {
        if (this.getDirectory() != commit.getDirectory()) {
            throw new UnsupportedOperationException("cannot compare IndexCommits from different Directory instances");
        }
        long gen = this.getGeneration();
        long comgen = commit.getGeneration();
        return Long.compare(gen, comgen);
    }

    StandardDirectoryReader getReader() {
        return null;
    }
}

