/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.standard;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import java.io.Reader;

public final class StandardAnalyzer
extends StopwordAnalyzerBase {
    private int maxTokenLength = 255;

    public StandardAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StandardAnalyzer() {
        this(CharArraySet.EMPTY_SET);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer src = new StandardTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new LowerCaseFilter(src);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader((Reader)r);
        }, (TokenStream)tok);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

