/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.item;

import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.item.GuideItem;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuideItemDispatchModel
implements ItemModel {
    private final ItemModel baseModel;
    private final ItemModel.BakingContext bakingContext;

    public GuideItemDispatchModel(ItemModel baseModel, ItemModel.BakingContext bakingContext) {
        this.baseModel = baseModel;
        this.bakingContext = bakingContext;
    }

    public void update(ItemStackRenderState renderState, ItemStack stack, ItemModelResolver itemModelResolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        MutableGuide guide;
        ItemModel itemModel = this.baseModel;
        ResourceLocation guideId = GuideItem.getGuideId(stack);
        if (guideId != null && (guide = GuideRegistry.getById(guideId)) != null && guide.getItemSettings().itemModel().isPresent()) {
            itemModel = new BlockModelWrapper.Unbaked(guide.getItemSettings().itemModel().get(), List.of()).bake(this.bakingContext);
        }
        itemModel.update(renderState, stack, itemModelResolver, displayContext, level, entity, seed);
    }
}

