/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.extensions;

import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytStandardRecipeBox;
import guideme.internal.GuidebookText;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VanillaRecipes {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaRecipes.class);

    private VanillaRecipes() {
    }

    public static Stream<LytStandardRecipeBox<CraftingRecipe>> createCrafting(RecipeHolder<CraftingRecipe> holder) {
        CraftingRecipe recipe = (CraftingRecipe)holder.value();
        Stream.Builder<LytStandardRecipeBox<CraftingRecipe>> result = Stream.builder();
        for (RecipeDisplay recipeDisplay : recipe.display()) {
            if (recipeDisplay instanceof ShapedCraftingRecipeDisplay) {
                ShapedCraftingRecipeDisplay shapedDisplay = (ShapedCraftingRecipeDisplay)recipeDisplay;
                LytSlotGrid grid = new LytSlotGrid(shapedDisplay.width(), shapedDisplay.height());
                List ingredients = shapedDisplay.ingredients();
                for (int x = 0; x < shapedDisplay.width(); ++x) {
                    for (int y = 0; y < shapedDisplay.height(); ++y) {
                        SlotDisplay slotDisplay;
                        int index = y * shapedDisplay.width() + x;
                        if (index >= ingredients.size() || (slotDisplay = (SlotDisplay)ingredients.get(index)).type() == SlotDisplay.Empty.TYPE) continue;
                        grid.setDisplay(x, y, slotDisplay);
                    }
                }
                result.add(LytStandardRecipeBox.builder().title(GuidebookText.Crafting.text().getString()).icon((ItemLike)Blocks.CRAFTING_TABLE).input(grid).outputFromResultOf(holder).build(holder));
                continue;
            }
            if (!(recipeDisplay instanceof ShapelessCraftingRecipeDisplay)) continue;
            ShapelessCraftingRecipeDisplay shapelessDisplay = (ShapelessCraftingRecipeDisplay)recipeDisplay;
            List ingredients = shapelessDisplay.ingredients();
            int ingredientCount = ingredients.size();
            LytSlotGrid grid = new LytSlotGrid(Math.min(3, ingredientCount), (ingredientCount + 2) / 3);
            for (int i = 0; i < ingredients.size(); ++i) {
                int col = i % 3;
                int row = i / 3;
                grid.setDisplay(col, row, (SlotDisplay)ingredients.get(i));
            }
            result.add(LytStandardRecipeBox.builder().title(GuidebookText.ShapelessCrafting.text().getString()).icon((ItemLike)Blocks.CRAFTING_TABLE).input(grid).outputFromResultOf(holder).build(holder));
        }
        return result.build();
    }

    public static Stream<LytStandardRecipeBox<SmeltingRecipe>> createSmelting(RecipeHolder<SmeltingRecipe> recipe) {
        return Stream.of(LytStandardRecipeBox.builder().title(GuidebookText.Smelting.text().getString()).icon((ItemLike)Blocks.FURNACE).input(LytSlotGrid.rowFromIngredients(List.of(((SmeltingRecipe)recipe.value()).input()), true)).outputFromResultOf(recipe).build(recipe));
    }

    public static Stream<LytStandardRecipeBox<BlastingRecipe>> createBlasting(RecipeHolder<BlastingRecipe> recipe) {
        return Stream.of(LytStandardRecipeBox.builder().title(GuidebookText.Blasting.text().getString()).icon((ItemLike)Blocks.BLAST_FURNACE).input(LytSlotGrid.rowFromIngredients(List.of(((BlastingRecipe)recipe.value()).input()), true)).outputFromResultOf(recipe).build(recipe));
    }

    public static Stream<LytStandardRecipeBox<SmithingRecipe>> createSmithing(RecipeHolder<SmithingRecipe> holder) {
        return Stream.of(LytStandardRecipeBox.builder().icon((ItemLike)Blocks.SMITHING_TABLE).title(Items.SMITHING_TABLE.getName().getString()).input(LytSlotGrid.rowFromIngredients(VanillaRecipes.getSmithingIngredients((SmithingRecipe)holder.value()), true)).outputFromResultOf(holder).build(holder));
    }

    private static List<Ingredient> getSmithingIngredients(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            SmithingTrimRecipe trimRecipe = (SmithingTrimRecipe)recipe;
            return Stream.of(trimRecipe.templateIngredient(), Optional.of(trimRecipe.baseIngredient()), trimRecipe.additionIngredient()).filter(Optional::isPresent).map(Optional::get).toList();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            SmithingTransformRecipe transformRecipe = (SmithingTransformRecipe)recipe;
            return Stream.of(transformRecipe.templateIngredient(), Optional.of(transformRecipe.baseIngredient()), transformRecipe.additionIngredient()).filter(Optional::isPresent).map(Optional::get).toList();
        }
        LOG.warn("Cannot determine ingredients of smithing recipe type {}", (Object)recipe.getClass());
        return List.of();
    }
}

