/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.compiler.ParsedGuidePage;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideMEServerProxy;
import guideme.internal.GuideRegistry;
import guideme.internal.GuidebookText;
import guideme.internal.MutableGuide;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.Nullable;

class GuideMEClientProxy
extends GuideMEServerProxy {
    GuideMEClientProxy() {
    }

    @Override
    public void addGuideTooltip(ResourceLocation guideId, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> lineConsumer, TooltipFlag tooltipFlag) {
        MutableGuide guide = GuideRegistry.getById(guideId);
        if (guide == null) {
            lineConsumer.accept((Component)GuidebookText.ItemInvalidGuideId.text().withStyle(ChatFormatting.RED));
            return;
        }
        guide.getItemSettings().tooltipLines().forEach(lineConsumer);
    }

    @Override
    @Nullable
    public Component getGuideDisplayName(ResourceLocation guideId) {
        MutableGuide guide = GuideRegistry.getById(guideId);
        if (guide != null) {
            return guide.getItemSettings().displayName().orElse(null);
        }
        return null;
    }

    @Override
    public boolean openGuide(Player player, ResourceLocation id) {
        if (player == Minecraft.getInstance().player) {
            Guide guide = Guides.getById(id);
            if (guide == null) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)GuidebookText.ItemInvalidGuideId.text(id.toString()), false);
                return false;
            }
            return GuideMEClient.openGuideAtPreviousPage(guide, guide.getStartPage());
        }
        return super.openGuide(player, id);
    }

    @Override
    public boolean openGuide(Player player, ResourceLocation id, PageAnchor anchor) {
        if (player == Minecraft.getInstance().player) {
            Guide guide = Guides.getById(id);
            if (guide == null) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)GuidebookText.ItemInvalidGuideId.text(id.toString()), false);
                return false;
            }
            if (anchor == null) {
                return GuideMEClient.openGuideAtPreviousPage(guide, guide.getStartPage());
            }
            return GuideMEClient.openGuideAtAnchor(guide, anchor);
        }
        return super.openGuide(player, id, anchor);
    }

    @Override
    public Stream<ResourceLocation> getAvailableGuides() {
        return Guides.getAll().stream().map(Guide::getId);
    }

    @Override
    public Stream<ResourceLocation> getAvailablePages(ResourceLocation guideId) {
        Guide guide = Guides.getById(guideId);
        if (guide == null) {
            return Stream.empty();
        }
        return guide.getPages().stream().map(ParsedGuidePage::getId);
    }
}

