/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.compiler.tags.RecipeTypeMappingSupplier;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.internal.util.Platform;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstNode;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeCompiler
extends BlockTagCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(RecipeCompiler.class);
    @Nullable
    private List<RecipeTypeMapping<?, ?>> sharedMappings;

    @Override
    public Set<String> getTagNames() {
        return Set.of("Recipe", "RecipeFor", "RecipesFor");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        RecipeMap recipeMap = Platform.getRecipeMap();
        if (recipeMap == null) {
            parent.appendError(compiler, "Cannot show recipe while not in-game", el);
            return;
        }
        if ("RecipesFor".equals(el.name())) {
            Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
            if (itemAndId == null) {
                return;
            }
            Item item = (Item)itemAndId.getRight();
            block0: for (RecipeHolder holder : recipeMap.values()) {
                Recipe recipe = holder.value();
                if (!Platform.recipeHasResult(recipe, item)) continue;
                for (RecipeTypeMapping<?, ?> mapping : this.getMappings(compiler)) {
                    Stream<LytBlock> blocks = mapping.tryCreate(holder);
                    if (blocks == null) continue;
                    Iterator it = blocks.iterator();
                    while (it.hasNext()) {
                        LytBlock block = (LytBlock)it.next();
                        block.setSourceNode((MdAstNode)((Object)el));
                        parent.append(block);
                    }
                    continue block0;
                }
            }
        } else if ("RecipeFor".equals(el.name())) {
            Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
            if (itemAndId == null) {
                return;
            }
            ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
            Item item = (Item)itemAndId.getRight();
            for (RecipeTypeMapping<?, ?> mapping : this.getMappings(compiler)) {
                LytBlock block = mapping.createFirst(recipeMap, item);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find recipe for " + String.valueOf(id), el);
        } else {
            ResourceLocation recipeId = MdxAttrs.getRequiredId(compiler, parent, el, "id");
            if (recipeId == null) {
                return;
            }
            RecipeHolder recipe = recipeMap.byKey(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId));
            if (recipe == null) {
                parent.appendError(compiler, "Couldn't find recipe " + String.valueOf(recipeId), el);
                return;
            }
            for (RecipeTypeMapping<?, ?> mapping : this.getMappings(compiler)) {
                Stream<LytBlock> blocks = mapping.tryCreate(recipe);
                if (blocks == null) continue;
                Iterator it = blocks.iterator();
                while (it.hasNext()) {
                    LytBlock block = (LytBlock)it.next();
                    block.setSourceNode((MdAstNode)((Object)el));
                    parent.append(block);
                }
                return;
            }
            parent.appendError(compiler, "Couldn't find a handler for recipe " + String.valueOf(recipeId), el);
        }
    }

    private Iterable<RecipeTypeMapping<?, ?>> getMappings(PageCompiler compiler) {
        final ArrayList result = new ArrayList();
        RecipeTypeMappingSupplier.RecipeTypeMappings mappings = new RecipeTypeMappingSupplier.RecipeTypeMappings(){

            @Override
            public <T extends Recipe<C>, C extends RecipeInput> void add(RecipeType<T> recipeType, Function<RecipeHolder<T>, Stream<? extends LytBlock>> factory) {
                result.add(new RecipeTypeMapping(recipeType, factory));
            }
        };
        for (RecipeTypeMappingSupplier extension : compiler.getExtensions(RecipeTypeMappingSupplier.EXTENSION_POINT)) {
            extension.collect(mappings);
        }
        result.addAll(this.getSharedMappings());
        return result;
    }

    private List<? extends RecipeTypeMapping<?, ?>> getSharedMappings() {
        if (this.sharedMappings != null) {
            return this.sharedMappings;
        }
        final HashSet recipeTypes = new HashSet();
        final ArrayList result = new ArrayList();
        RecipeTypeMappingSupplier.RecipeTypeMappings mappings = new RecipeTypeMappingSupplier.RecipeTypeMappings(){

            @Override
            public <T extends Recipe<C>, C extends RecipeInput> void add(RecipeType<T> recipeType, Function<RecipeHolder<T>, Stream<? extends LytBlock>> factory) {
                Objects.requireNonNull(recipeType, "recipeType");
                Objects.requireNonNull(factory, "factory");
                recipeTypes.add(BuiltInRegistries.RECIPE_TYPE.getKey(recipeType));
                result.add(new RecipeTypeMapping(recipeType, factory));
            }
        };
        Iterator it = ServiceLoader.load(RecipeTypeMappingSupplier.class).stream().iterator();
        while (it.hasNext()) {
            ServiceLoader.Provider provider = (ServiceLoader.Provider)it.next();
            try {
                ((RecipeTypeMappingSupplier)provider.get()).collect(mappings);
            }
            catch (Exception e) {
                LOG.error("Failed to collect shared recipe type mappings from {}", provider.type(), (Object)e);
            }
        }
        ArrayList recipeTypesSorted = new ArrayList(recipeTypes);
        Collections.sort(recipeTypesSorted);
        LOG.info("Discovered shared recipe type mappings: {}", recipeTypesSorted);
        this.sharedMappings = List.copyOf(result);
        return this.sharedMappings;
    }

    private static final class RecipeTypeMapping<T extends Recipe<C>, C extends RecipeInput>
    extends Record {
        private final RecipeType<T> recipeType;
        private final Function<RecipeHolder<T>, Stream<? extends LytBlock>> factory;

        private RecipeTypeMapping(RecipeType<T> recipeType, Function<RecipeHolder<T>, Stream<? extends LytBlock>> factory) {
            this.recipeType = recipeType;
            this.factory = factory;
        }

        @Nullable
        LytBlock createFirst(RecipeMap recipeMap, Item resultItem) {
            Iterator result = this.createAll(recipeMap, resultItem).iterator();
            if (result.hasNext()) {
                return (LytBlock)result.next();
            }
            return null;
        }

        Stream<LytBlock> createAll(RecipeMap recipeMap, Item resultItem) {
            Stream<LytBlock> result = Stream.empty();
            ArrayList<RecipeHolder> fallbackCandidates = new ArrayList<RecipeHolder>();
            for (RecipeHolder holder : recipeMap.byType(this.recipeType)) {
                if (holder.value().isSpecial()) {
                    fallbackCandidates.add(holder);
                    continue;
                }
                if (!Platform.recipeHasResult(holder.value(), resultItem)) continue;
                result = Stream.concat(result, this.factory.apply(holder));
            }
            for (RecipeHolder holder : fallbackCandidates) {
                if (!Platform.recipeHasResult(holder.value(), resultItem)) continue;
                result = Stream.concat(result, this.factory.apply(holder));
            }
            return result;
        }

        @Nullable
        Stream<? extends LytBlock> tryCreate(RecipeHolder<?> recipe) {
            if (this.recipeType == recipe.value().getType()) {
                return this.factory.apply(recipe);
            }
            return null;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RecipeTypeMapping.class, "recipeType;factory", "recipeType", "factory"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RecipeTypeMapping.class, "recipeType;factory", "recipeType", "factory"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RecipeTypeMapping.class, "recipeType;factory", "recipeType", "factory"}, this, o);
        }
    }
}

