/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import com.google.flatbuffers.FlatBufferBuilder;
import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import guideme.flatbuffers.scene.ExpAnimatedTexturePart;
import guideme.flatbuffers.scene.ExpAnimatedTexturePartFrame;
import guideme.flatbuffers.scene.ExpCameraSettings;
import guideme.flatbuffers.scene.ExpMaterial;
import guideme.flatbuffers.scene.ExpMesh;
import guideme.flatbuffers.scene.ExpSampler;
import guideme.flatbuffers.scene.ExpScene;
import guideme.flatbuffers.scene.ExpVertexFormat;
import guideme.flatbuffers.scene.ExpVertexFormatElement;
import guideme.internal.siteexport.CacheBusting;
import guideme.internal.util.Platform;
import guideme.scene.CameraSettings;
import guideme.scene.GuidebookLevelRenderer;
import guideme.scene.GuidebookScene;
import guideme.scene.export.InterpolatedSpriteBuilder;
import guideme.scene.export.Mesh;
import guideme.scene.export.MeshBuildingBufferSource;
import guideme.scene.export.RenderTypeIntrospection;
import guideme.scene.level.GuidebookLevel;
import guideme.siteexport.ResourceExporter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneExporter {
    private static final Logger LOG = LoggerFactory.getLogger(SceneExporter.class);
    private final ResourceExporter resourceExporter;

    public SceneExporter(ResourceExporter resourceExporter) {
        this.resourceExporter = resourceExporter;
    }

    public static boolean isAnimated(GuidebookScene scene) {
        return SceneExporter.getSprites(scene).stream().anyMatch(sprite -> sprite.contents().animatedTexture != null);
    }

    private static Set<TextureAtlasSprite> getSprites(GuidebookScene scene) {
        GuidebookLevel level = scene.getLevel();
        MeshBuildingBufferSource bufferSource = new MeshBuildingBufferSource();
        GuidebookLevelRenderer.getInstance().renderContent(level, bufferSource);
        return bufferSource.getMeshes().stream().flatMap(Mesh::getSprites).collect(Collectors.toSet());
    }

    public byte[] export(GuidebookScene scene) {
        GuidebookLevel level = scene.getLevel();
        MeshBuildingBufferSource bufferSource = new MeshBuildingBufferSource();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f(), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        GuidebookLevelRenderer.getInstance().renderContent(level, bufferSource);
        modelViewStack.popMatrix();
        RenderSystem.restoreProjectionMatrix();
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        List<Mesh> meshes = bufferSource.getMeshes();
        int animatedTexturesOffset = this.writeAnimations(builder, meshes);
        Map<VertexFormat, Integer> vertexFormats = this.writeVertexFormats(meshes, builder);
        Map<RenderType, Integer> materials = this.writeMaterials(meshes, builder);
        int meshesOffset = this.writeMeshes(meshes, builder, vertexFormats, materials);
        ExpScene.startExpScene(builder);
        ExpScene.addMeshes(builder, meshesOffset);
        int cameraOffset = this.createCameraModel(scene.getCameraSettings(), builder);
        ExpScene.addCamera(builder, cameraOffset);
        ExpScene.addAnimatedTextures(builder, animatedTexturesOffset);
        builder.finish(ExpScene.endExpScene(builder));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(bout);){
            out.write(builder.sizedByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bout.toByteArray();
    }

    private int writeAnimations(FlatBufferBuilder builder, List<Mesh> meshes) {
        int[] animSprites = meshes.stream().flatMap(Mesh::getSprites).filter(s -> s.contents().animatedTexture != null).distinct().mapToInt(sprite -> this.writeAnimatedTextureSprite(builder, (TextureAtlasSprite)sprite)).toArray();
        return ExpScene.createAnimatedTexturesVector(builder, animSprites);
    }

    private int writeAnimatedTextureSprite(FlatBufferBuilder builder, TextureAtlasSprite sprite) {
        int framesOffset;
        long frameCount;
        int frameRowSize;
        byte[] image;
        SpriteContents contents = sprite.contents();
        SpriteContents.AnimatedTexture animatedTexture = contents.animatedTexture;
        ResourceLocation name = contents.name();
        if (animatedTexture.interpolateFrames) {
            InterpolatedSpriteBuilder.InterpolatedResult interpResult = InterpolatedSpriteBuilder.interpolate(contents.originalImage, contents.width(), contents.height(), animatedTexture.frameRowSize, animatedTexture.frames);
            try (NativeImage interpFrames = interpResult.frames();){
                image = Platform.exportAsPng((NativeImage)interpFrames);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            frameRowSize = interpResult.frameRowSize();
            frameCount = interpResult.frameCount();
            ExpAnimatedTexturePart.startFramesVector(builder, interpResult.indices().length);
            for (int frameIndex : interpResult.indices()) {
                ExpAnimatedTexturePartFrame.createExpAnimatedTexturePartFrame(builder, frameIndex, 1);
            }
            framesOffset = builder.endVector();
        } else {
            try {
                image = Platform.exportAsPng((NativeImage)contents.originalImage);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            frameCount = animatedTexture.getUniqueFrames().count();
            frameRowSize = animatedTexture.frameRowSize;
            ExpAnimatedTexturePart.startFramesVector(builder, animatedTexture.frames.size());
            for (SpriteContents.FrameInfo frame : animatedTexture.frames) {
                ExpAnimatedTexturePartFrame.createExpAnimatedTexturePartFrame(builder, frame.index(), frame.time());
            }
            framesOffset = builder.endVector();
        }
        Path path = this.resourceExporter.getOutputFolder().resolve("!anims").resolve(name.getNamespace()).resolve(name.getPath() + ".png");
        try {
            path = CacheBusting.writeAsset((Path)path, (byte[])image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String relativePath = this.resourceExporter.getPathRelativeFromOutputFolder(path);
        int textureIdOffset = builder.createSharedString(sprite.atlasLocation().toString());
        int spritePath = builder.createString((CharSequence)relativePath);
        return ExpAnimatedTexturePart.createExpAnimatedTexturePart(builder, textureIdOffset, sprite.getX(), sprite.getY(), contents.width(), contents.height(), spritePath, frameCount, frameRowSize, framesOffset);
    }

    private Map<VertexFormat, Integer> writeVertexFormats(List<Mesh> meshes, FlatBufferBuilder builder) {
        IdentityHashMap<VertexFormat, Integer> result = new IdentityHashMap<VertexFormat, Integer>();
        for (Mesh mesh : meshes) {
            result.computeIfAbsent(mesh.drawState().format(), format -> this.writeVertexFormat((VertexFormat)format, builder));
        }
        return result;
    }

    private int writeVertexFormat(VertexFormat format, FlatBufferBuilder builder) {
        int count = (int)format.getElements().stream().filter(SceneExporter::isRelevant).count();
        ExpVertexFormat.startElementsVector(builder, count);
        List elements = format.getElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            int offset = 0;
            for (int j = 0; j < i; ++j) {
                offset += ((VertexFormatElement)elements.get(j)).byteSize();
            }
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            if (!SceneExporter.isRelevant(element)) continue;
            boolean normalized = element.usage() == VertexFormatElement.Usage.NORMAL || element.usage() == VertexFormatElement.Usage.COLOR;
            ExpVertexFormatElement.createExpVertexFormatElement(builder, element.index(), SceneExporter.mapType(element.type()), SceneExporter.mapUsage(element.usage()), element.count(), offset, element.byteSize(), normalized);
        }
        int elementsOffset = builder.endVector();
        ExpVertexFormat.startExpVertexFormat(builder);
        ExpVertexFormat.addElements(builder, elementsOffset);
        ExpVertexFormat.addVertexSize(builder, format.getVertexSize());
        return ExpVertexFormat.endExpVertexFormat(builder);
    }

    private static boolean isRelevant(VertexFormatElement element) {
        return element.usage() != VertexFormatElement.Usage.GENERIC;
    }

    private Map<RenderType, Integer> writeMaterials(List<Mesh> meshes, FlatBufferBuilder builder) {
        IdentityHashMap<RenderType, Integer> result = new IdentityHashMap<RenderType, Integer>();
        for (Mesh mesh : meshes) {
            result.computeIfAbsent(mesh.renderType(), type -> this.writeMaterial((RenderType)type, builder));
        }
        return result;
    }

    private int writeMaterial(RenderType type, FlatBufferBuilder builder) {
        int depthTest;
        int transparency;
        RenderType.CompositeState state = ((RenderType.CompositeRenderType)type).state;
        RenderPipeline pipeline = type.getRenderPipeline();
        int shaderNameOffset = builder.createSharedString(pipeline.getLocation().toString());
        int nameOffset = builder.createSharedString(type.name);
        boolean disableCulling = !pipeline.isCull();
        BlendFunction transparencyState = pipeline.getBlendFunction().orElse(null);
        if (transparencyState == null) {
            transparency = 0;
        } else if (transparencyState.equals((Object)BlendFunction.ADDITIVE)) {
            transparency = 1;
        } else if (transparencyState.equals((Object)BlendFunction.LIGHTNING)) {
            transparency = 2;
        } else if (transparencyState.equals((Object)BlendFunction.GLINT)) {
            transparency = 3;
        } else if (transparencyState.equals(RenderPipelines.CRUMBLING.getBlendFunction().orElse(null))) {
            transparency = 4;
        } else if (transparencyState.equals((Object)BlendFunction.TRANSLUCENT)) {
            transparency = 5;
        } else {
            LOG.warn("Cannot handle transparency state {} of render type {}", (Object)transparencyState, (Object)type);
            transparency = 0;
        }
        DepthTestFunction depthTestShard = pipeline.getDepthTestFunction();
        if (depthTestShard == DepthTestFunction.NO_DEPTH_TEST) {
            depthTest = 0;
        } else if (depthTestShard == DepthTestFunction.EQUAL_DEPTH_TEST) {
            depthTest = 1;
        } else if (depthTestShard == DepthTestFunction.LEQUAL_DEPTH_TEST) {
            depthTest = 2;
        } else if (depthTestShard == DepthTestFunction.GREATER_DEPTH_TEST) {
            depthTest = 3;
        } else {
            LOG.warn("Cannot handle depth-test state {} of render type {}", (Object)depthTestShard, (Object)type);
            depthTest = 0;
        }
        int samplersOffset = 0;
        List<RenderTypeIntrospection.Sampler> samplers = RenderTypeIntrospection.getSamplers(type);
        if (!samplers.isEmpty()) {
            RenderTypeIntrospection.Sampler sampler = samplers.get(0);
            String texturePath = this.resourceExporter.exportTexture(sampler.texture());
            int textureOffset = builder.createSharedString(texturePath);
            int textureIdOffset = builder.createSharedString(sampler.texture().toString());
            int samplerOffset = ExpSampler.createExpSampler(builder, textureIdOffset, textureOffset, sampler.blur(), sampler.blur());
            samplersOffset = ExpMaterial.createSamplersVector(builder, new int[]{samplerOffset});
        }
        return ExpMaterial.createExpMaterial(builder, nameOffset, shaderNameOffset, disableCulling, transparency, depthTest, samplersOffset);
    }

    private static int mapMode(VertexFormat.Mode mode) {
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case VertexFormat.Mode.LINES -> 0;
            case VertexFormat.Mode.LINE_STRIP -> 1;
            case VertexFormat.Mode.DEBUG_LINES -> 2;
            case VertexFormat.Mode.DEBUG_LINE_STRIP -> 3;
            case VertexFormat.Mode.QUADS, VertexFormat.Mode.TRIANGLES -> 4;
            case VertexFormat.Mode.TRIANGLE_STRIP -> 5;
            case VertexFormat.Mode.TRIANGLE_FAN -> 6;
        };
    }

    private static int mapUsage(VertexFormatElement.Usage usage) {
        return switch (usage) {
            default -> throw new MatchException(null, null);
            case VertexFormatElement.Usage.POSITION -> 0;
            case VertexFormatElement.Usage.NORMAL -> 1;
            case VertexFormatElement.Usage.COLOR -> 2;
            case VertexFormatElement.Usage.UV -> 3;
            case VertexFormatElement.Usage.GENERIC -> throw new IllegalStateException("Should have been skipped");
        };
    }

    private static int mapType(VertexFormatElement.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case VertexFormatElement.Type.FLOAT -> 0;
            case VertexFormatElement.Type.UBYTE -> 1;
            case VertexFormatElement.Type.BYTE -> 2;
            case VertexFormatElement.Type.USHORT -> 3;
            case VertexFormatElement.Type.SHORT -> 4;
            case VertexFormatElement.Type.UINT -> 5;
            case VertexFormatElement.Type.INT -> 6;
        };
    }

    private int writeMeshes(List<Mesh> meshes, FlatBufferBuilder builder, Map<VertexFormat, Integer> vertexFormats, Map<RenderType, Integer> materials) {
        IntArrayList writtenMeshes = new IntArrayList(meshes.size());
        for (Mesh mesh : meshes) {
            int vb = ExpMesh.createVertexBufferVector(builder, mesh.vertexBuffer());
            IndexBufferAttributes ibData = this.createIndexBuffer(mesh.drawState(), mesh.indexBuffer());
            int ib = ExpMesh.createIndexBufferVector(builder, ibData.data);
            ExpMesh.startExpMesh(builder);
            ExpMesh.addVertexBuffer(builder, vb);
            ExpMesh.addIndexBuffer(builder, ib);
            ExpMesh.addIndexType(builder, this.mapIndexType(ibData.indexType));
            ExpMesh.addIndexCount(builder, ibData.indexCount);
            ExpMesh.addMaterial(builder, materials.get(mesh.renderType()));
            ExpMesh.addVertexFormat(builder, vertexFormats.get(mesh.drawState().format()));
            ExpMesh.addPrimitiveType(builder, SceneExporter.mapMode(mesh.drawState().mode()));
            writtenMeshes.add(ExpMesh.endExpMesh(builder));
        }
        return ExpScene.createMeshesVector(builder, writtenMeshes.elements());
    }

    private int mapIndexType(VertexFormat.IndexType indexType) {
        return switch (indexType) {
            default -> throw new MatchException(null, null);
            case VertexFormat.IndexType.INT -> 0;
            case VertexFormat.IndexType.SHORT -> 1;
        };
    }

    private IndexBufferAttributes createIndexBuffer(MeshData.DrawState drawState, ByteBuffer idxBuffer) {
        ByteBuffer effectiveIndices;
        VertexFormat.IndexType indexType = drawState.indexType();
        int indexCount = drawState.indexCount();
        VertexFormat.Mode mode = drawState.mode();
        if (idxBuffer == null) {
            GeneratedIndexBuffer generated = this.generateSequentialIndices(mode, drawState.vertexCount(), drawState.indexCount());
            effectiveIndices = generated.data;
            indexType = generated.type;
            indexCount = generated.indexCount();
        } else if (indexType == VertexFormat.IndexType.SHORT) {
            if (mode == VertexFormat.Mode.QUADS) {
                ShortBuffer idxShortBuffer = idxBuffer.asShortBuffer();
                ShortBuffer triIndices = ShortBuffer.allocate(idxShortBuffer.remaining() * 2);
                while (idxShortBuffer.hasRemaining()) {
                    short one = idxShortBuffer.get();
                    short two = idxShortBuffer.get();
                    short three = idxShortBuffer.get();
                    short four = idxShortBuffer.get();
                    triIndices.put(one);
                    triIndices.put(two);
                    triIndices.put(three);
                    triIndices.put(three);
                    triIndices.put(four);
                    triIndices.put(one);
                }
                triIndices.flip();
                effectiveIndices = ByteBuffer.allocate(triIndices.remaining() * 2).order(ByteOrder.nativeOrder());
                while (triIndices.hasRemaining()) {
                    effectiveIndices.putShort(triIndices.get());
                }
            } else {
                effectiveIndices = idxBuffer;
            }
        } else if (indexType == VertexFormat.IndexType.INT) {
            if (mode == VertexFormat.Mode.QUADS) {
                IntBuffer idxIntBuffer = idxBuffer.asIntBuffer();
                IntBuffer triIndices = IntBuffer.allocate(idxIntBuffer.remaining() * 2);
                while (idxIntBuffer.hasRemaining()) {
                    int one = idxIntBuffer.get();
                    int two = idxIntBuffer.get();
                    int three = idxIntBuffer.get();
                    int four = idxIntBuffer.get();
                    triIndices.put(one);
                    triIndices.put(two);
                    triIndices.put(three);
                    triIndices.put(three);
                    triIndices.put(four);
                    triIndices.put(one);
                }
                triIndices.flip();
                effectiveIndices = ByteBuffer.allocate(triIndices.remaining() * 4).order(ByteOrder.nativeOrder());
                while (triIndices.hasRemaining()) {
                    effectiveIndices.putInt(triIndices.get());
                }
            } else {
                effectiveIndices = idxBuffer;
            }
        } else {
            throw new RuntimeException("Unknown index type: " + String.valueOf(indexType));
        }
        return new IndexBufferAttributes(effectiveIndices, indexType, indexCount);
    }

    private GeneratedIndexBuffer generateSequentialIndices(VertexFormat.Mode mode, int vertexCount, int expectedIndexCount) {
        int indicesPerPrimitive = switch (mode) {
            case VertexFormat.Mode.LINES -> 2;
            case VertexFormat.Mode.DEBUG_LINES -> 2;
            case VertexFormat.Mode.TRIANGLES -> 3;
            case VertexFormat.Mode.QUADS -> 6;
            default -> throw new UnsupportedOperationException();
        };
        int verticesPerPrimitive = switch (mode) {
            case VertexFormat.Mode.LINES -> 2;
            case VertexFormat.Mode.DEBUG_LINES -> 2;
            case VertexFormat.Mode.TRIANGLES -> 3;
            case VertexFormat.Mode.QUADS -> 4;
            default -> throw new UnsupportedOperationException();
        };
        int primitives = vertexCount / verticesPerPrimitive;
        int indexCount = primitives * indicesPerPrimitive;
        if (indexCount != expectedIndexCount) {
            throw new RuntimeException("Would generate " + indexCount + " but MC expected " + expectedIndexCount);
        }
        VertexFormat.IndexType indexType = VertexFormat.IndexType.least((int)indexCount);
        ByteBuffer buffer = ByteBuffer.allocate(indexType.bytes * indexCount).order(ByteOrder.nativeOrder());
        IntConsumer indexConsumer = indexType == VertexFormat.IndexType.SHORT ? value -> buffer.putShort((short)value) : buffer::putInt;
        block15: for (int i = 0; i < vertexCount; i += verticesPerPrimitive) {
            switch (mode) {
                case QUADS: {
                    indexConsumer.accept(i + 0);
                    indexConsumer.accept(i + 1);
                    indexConsumer.accept(i + 2);
                    indexConsumer.accept(i + 2);
                    indexConsumer.accept(i + 3);
                    indexConsumer.accept(i + 0);
                    continue block15;
                }
                default: {
                    IntStream.range(0, indexCount).forEach(indexConsumer);
                }
            }
        }
        buffer.flip();
        return new GeneratedIndexBuffer(indexType, buffer, indexCount);
    }

    private int createCameraModel(CameraSettings cameraSettings, FlatBufferBuilder builder) {
        return ExpCameraSettings.createExpCameraSettings(builder, cameraSettings.getRotationY(), cameraSettings.getRotationX(), cameraSettings.getRotationZ(), cameraSettings.getZoom());
    }

    record IndexBufferAttributes(ByteBuffer data, VertexFormat.IndexType indexType, int indexCount) {
    }

    record GeneratedIndexBuffer(VertexFormat.IndexType type, ByteBuffer data, int indexCount) {
    }
}

