/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.document.LytRect;
import guideme.document.block.LytBox;
import guideme.document.block.LytSlot;
import guideme.layout.LayoutContext;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public class LytSlotGrid
extends LytBox {
    private final int width;
    private final int height;
    private final LytSlot[] slots;
    private boolean renderEmptySlots = true;

    public LytSlotGrid(int width, int height) {
        this.width = width;
        this.height = height;
        this.slots = new LytSlot[width * height];
    }

    public static LytSlotGrid columnFromStacks(List<ItemStack> items, boolean skipEmpty) {
        return LytSlotGrid.columnFromDisplays(items.stream().map(SlotDisplay.ItemStackSlotDisplay::new).toList(), skipEmpty);
    }

    public static LytSlotGrid rowFromStacks(List<ItemStack> items, boolean skipEmpty) {
        return LytSlotGrid.rowFromDisplays(items.stream().map(SlotDisplay.ItemStackSlotDisplay::new).toList(), skipEmpty);
    }

    public static LytSlotGrid columnFromIngredients(List<Ingredient> ingredients, boolean skipEmpty) {
        if (!skipEmpty) {
            LytSlotGrid grid = new LytSlotGrid(1, ingredients.size());
            for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                grid.setIngredient(0, i2, ingredients.get(i2));
            }
            return grid;
        }
        int nonEmptyIngredients = (int)ingredients.stream().filter(i -> !i.isEmpty()).count();
        LytSlotGrid grid = new LytSlotGrid(1, nonEmptyIngredients);
        int index = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            grid.setIngredient(0, index++, ingredient);
        }
        return grid;
    }

    public static LytSlotGrid rowFromIngredients(List<Ingredient> ingredients, boolean skipEmpty) {
        if (!skipEmpty) {
            LytSlotGrid grid = new LytSlotGrid(ingredients.size(), 1);
            for (int i2 = 0; i2 < ingredients.size(); ++i2) {
                grid.setIngredient(i2, 0, ingredients.get(i2));
            }
            return grid;
        }
        int nonEmptyIngredients = (int)ingredients.stream().filter(i -> !i.isEmpty()).count();
        LytSlotGrid grid = new LytSlotGrid(nonEmptyIngredients, 1);
        int index = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            grid.setIngredient(index++, 0, ingredient);
        }
        return grid;
    }

    public static LytSlotGrid columnFromDisplays(List<? extends SlotDisplay> displays, boolean skipEmpty) {
        if (!skipEmpty) {
            LytSlotGrid grid = new LytSlotGrid(1, displays.size());
            for (int i = 0; i < displays.size(); ++i) {
                grid.setDisplay(0, i, displays.get(i));
            }
            return grid;
        }
        int nonEmptyDisplays = (int)displays.stream().filter(d -> !LytSlotGrid.isEmpty(d)).count();
        LytSlotGrid grid = new LytSlotGrid(1, nonEmptyDisplays);
        int index = 0;
        for (SlotDisplay slotDisplay : displays) {
            if (LytSlotGrid.isEmpty(slotDisplay)) continue;
            grid.setDisplay(0, index++, slotDisplay);
        }
        return grid;
    }

    public static LytSlotGrid rowFromDisplays(List<? extends SlotDisplay> displays, boolean skipEmpty) {
        if (!skipEmpty) {
            LytSlotGrid grid = new LytSlotGrid(displays.size(), 1);
            for (int i = 0; i < displays.size(); ++i) {
                grid.setDisplay(i, 0, displays.get(i));
            }
            return grid;
        }
        int nonEmptyDisplays = (int)displays.stream().filter(d -> !LytSlotGrid.isEmpty(d)).count();
        LytSlotGrid grid = new LytSlotGrid(nonEmptyDisplays, 1);
        int index = 0;
        for (SlotDisplay slotDisplay : displays) {
            if (LytSlotGrid.isEmpty(slotDisplay)) continue;
            grid.setDisplay(index++, 0, slotDisplay);
        }
        return grid;
    }

    public boolean isRenderEmptySlots() {
        return this.renderEmptySlots;
    }

    public void setRenderEmptySlots(boolean renderEmptySlots) {
        this.renderEmptySlots = renderEmptySlots;
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                LytSlot slot;
                int index = this.getSlotIndex(col, row);
                if (index >= this.slots.length || (slot = this.slots[index]) == null) continue;
                slot.layout(context, x + col * 18, y + row * 18, availableWidth);
            }
        }
        return new LytRect(x, y, 18 * this.width, 18 * this.height);
    }

    public void setItem(int x, int y, ItemStack item) {
        this.setDisplay(x, y, (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(item));
    }

    public void setIngredient(int x, int y, Ingredient ingredient) {
        this.setSlot(x, y, new LytSlot(ingredient));
    }

    public void setDisplay(int x, int y, SlotDisplay display) {
        this.setSlot(x, y, new LytSlot(display));
    }

    private void setSlot(int x, int y, LytSlot newSlot) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("x: " + x);
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("y: " + y);
        }
        int slotIndex = this.getSlotIndex(x, y);
        LytSlot slot = this.slots[slotIndex];
        if (slot != null) {
            slot.removeChild(slot);
            this.slots[slotIndex] = null;
        }
        slot = this.slots[slotIndex] = newSlot;
        this.append(slot);
    }

    @Override
    public void render(RenderContext context) {
        if (this.renderEmptySlots) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int index = this.getSlotIndex(x, y);
                    if (index < this.slots.length && this.slots[index] != null) continue;
                    context.drawIcon(this.bounds.x() + 18 * x, this.bounds.y() + 18 * y, GuiAssets.SLOT_BACKGROUND);
                }
            }
        }
        super.render(context);
    }

    private int getSlotIndex(int col, int row) {
        return row * this.width + col;
    }

    private static boolean isEmpty(SlotDisplay d) {
        return d.type() == SlotDisplay.Empty.TYPE;
    }
}

