/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.NormalizeIdentifier;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactoryDestination;
import guideme.libs.micromark.factory.FactoryLabel;
import guideme.libs.micromark.factory.FactoryTitle;
import guideme.libs.micromark.factory.FactoryWhitespace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class LabelEnd {
    public static final Construct labelEnd = new Construct();
    public static final Construct resourceConstruct;
    public static final Construct fullReferenceConstruct;
    public static final Construct collapsedReferenceConstruct;

    public static List<Tokenizer.Event> resolveAll(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = -1;
        while (++index < events.size()) {
            Token token = events.get(index).token();
            if (!token.type.equals("labelImage") && !token.type.equals("labelLink") && !token.type.equals("labelEnd")) continue;
            ListUtils.splice(events, index + 1, token.type.equals("labelImage") ? 4 : 2);
            token.type = "data";
            ++index;
        }
        return events;
    }

    private static List<Tokenizer.Event> resolveToLabelEnd(List<Tokenizer.Event> events, TokenizeContext context) {
        int index = events.size();
        int offset = 0;
        Integer open = null;
        Integer close = null;
        while (index-- > 0) {
            Token token = events.get(index).token();
            if (open != null) {
                if (token.type.equals("link") || token.type.equals("labelLink") && token._inactive) break;
                if (!events.get(index).isEnter() || !token.type.equals("labelLink")) continue;
                token._inactive = true;
                continue;
            }
            if (close != null) {
                if (!events.get(index).isEnter() || !token.type.equals("labelImage") && !token.type.equals("labelLink") || token._balanced) continue;
                open = index;
                if (token.type.equals("labelLink")) continue;
                offset = 2;
                break;
            }
            if (!token.type.equals("labelEnd")) continue;
            close = index;
        }
        Assert.check(open != null, "`open` is supposed to be found");
        Assert.check(close != null, "`close` is supposed to be found");
        Token group = new Token();
        group.type = events.get((int)open.intValue()).token().type.equals("labelLink") ? "link" : "image";
        group.start = events.get((int)open.intValue()).token().start;
        group.end = events.get((int)(events.size() - 1)).token().end;
        Token label = new Token();
        label.type = "label";
        label.start = events.get((int)open.intValue()).token().start;
        label.end = events.get((int)close.intValue()).token().end;
        Token text = new Token();
        text.type = "labelText";
        text.start = events.get((int)(open.intValue() + offset + 2)).token().end;
        text.end = events.get((int)(close.intValue() - 2)).token().start;
        List<Tokenizer.Event> media = new ArrayList<Tokenizer.Event>();
        media.add(Tokenizer.Event.enter(group, context));
        media.add(Tokenizer.Event.enter(label, context));
        media = ListUtils.push(media, events.subList(open + 1, open + offset + 3));
        media = ListUtils.push(media, List.of(Tokenizer.Event.enter(text, context)));
        media = ListUtils.push(media, Construct.resolveAll(context.getParser().constructs.nullInsideSpan, ListUtils.slice(events, open + offset + 4, close - 3), context));
        media = ListUtils.push(media, List.of(Tokenizer.Event.exit(text, context), events.get(close - 2), events.get(close - 1), Tokenizer.Event.exit(label, context)));
        media = ListUtils.push(media, events.subList(close + 1, events.size()));
        media = ListUtils.push(media, List.of(Tokenizer.Event.exit(group, context)));
        ListUtils.splice(events, open, events.size(), media);
        return events;
    }

    static {
        LabelEnd.labelEnd.name = "labelEnd";
        LabelEnd.labelEnd.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        LabelEnd.labelEnd.resolveTo = LabelEnd::resolveToLabelEnd;
        LabelEnd.labelEnd.resolveAll = LabelEnd::resolveAll;
        resourceConstruct = new Construct();
        LabelEnd.resourceConstruct.tokenize = (context, effects, ok, nok) -> new ResourceStateMachine(context, effects, ok, nok)::start;
        fullReferenceConstruct = new Construct();
        LabelEnd.fullReferenceConstruct.tokenize = (context, effects, ok, nok) -> new FullReferenceStateMachine(context, effects, ok, nok)::start;
        collapsedReferenceConstruct = new Construct();
        LabelEnd.collapsedReferenceConstruct.tokenize = (context, effects, ok, nok) -> new CollapsedReferenceStateMachine(context, effects, ok, nok)::start;
    }

    private static class CollapsedReferenceStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public CollapsedReferenceStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 91, "expected left bracket");
            this.effects.enter("reference");
            this.effects.enter("referenceMarker");
            this.effects.consume(code);
            this.effects.exit("referenceMarker");
            return this::open;
        }

        private State open(int code) {
            if (code == 93) {
                this.effects.enter("referenceMarker");
                this.effects.consume(code);
                this.effects.exit("referenceMarker");
                this.effects.exit("reference");
                return this.ok;
            }
            return this.nok.step(code);
        }
    }

    private static class FullReferenceStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public FullReferenceStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 91, "expected left bracket");
            return FactoryLabel.create(this.context, this.effects, this::afterLabel, this.nok, "reference", "referenceMarker", "referenceString").step(code);
        }

        private State afterLabel(int code) {
            String lastTokenText = this.context.sliceSerialize(this.context.getLastEvent().token());
            return this.context.getParser().defined.contains(NormalizeIdentifier.normalizeIdentifier(lastTokenText.substring(1, lastTokenText.length() - 1))) ? this.ok.step(code) : this.nok.step(code);
        }
    }

    private static class ResourceStateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;

        public ResourceStateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 40, "expected left paren");
            this.effects.enter("resource");
            this.effects.enter("resourceMarker");
            this.effects.consume(code);
            this.effects.exit("resourceMarker");
            return FactoryWhitespace.create(this.effects, this::open);
        }

        private State open(int code) {
            if (code == 41) {
                return this.end(code);
            }
            return FactoryDestination.create(this.effects, this::destinationAfter, this.nok, "resourceDestination", "resourceDestinationLiteral", "resourceDestinationLiteralMarker", "resourceDestinationRaw", "resourceDestinationString", 32).step(code);
        }

        private State destinationAfter(int code) {
            return CharUtil.markdownLineEndingOrSpace(code) ? FactoryWhitespace.create(this.effects, this::between).step(code) : this.end(code);
        }

        private State between(int code) {
            if (code == 34 || code == 39 || code == 40) {
                return FactoryTitle.create(this.effects, FactoryWhitespace.create(this.effects, this::end), this.nok, "resourceTitle", "resourceTitleMarker", "resourceTitleString").step(code);
            }
            return this.end(code);
        }

        private State end(int code) {
            if (code == 41) {
                this.effects.enter("resourceMarker");
                this.effects.consume(code);
                this.effects.exit("resourceMarker");
                this.effects.exit("resource");
                return this.ok;
            }
            return this.nok.step(code);
        }
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        int index;
        @Nullable
        Token labelStart;
        boolean defined = false;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.index = context.getEvents().size();
            while (this.index-- > 0) {
                if (!context.getEvents().get((int)this.index).token().type.equals("labelImage") && !context.getEvents().get((int)this.index).token().type.equals("labelLink") || context.getEvents().get((int)this.index).token()._balanced) continue;
                this.labelStart = context.getEvents().get(this.index).token();
                break;
            }
        }

        private State start(int code) {
            Assert.check(code == 93, "expected `]`");
            if (this.labelStart == null) {
                return this.nok.step(code);
            }
            if (this.labelStart._inactive) {
                return this.balanced(code);
            }
            this.defined = this.context.getParser().defined.contains(NormalizeIdentifier.normalizeIdentifier(this.context.sliceSerialize(this.labelStart.end, this.context.now())));
            this.effects.enter("labelEnd");
            this.effects.enter("labelMarker");
            this.effects.consume(code);
            this.effects.exit("labelMarker");
            this.effects.exit("labelEnd");
            return this::afterLabelEnd;
        }

        private State afterLabelEnd(int code) {
            if (code == 40) {
                return this.effects.attempt.hook(resourceConstruct, this.ok, this.defined ? this.ok : this::balanced).step(code);
            }
            if (code == 91) {
                return this.effects.attempt.hook(fullReferenceConstruct, this.ok, this.defined ? this.effects.attempt.hook(collapsedReferenceConstruct, this.ok, this::balanced) : this::balanced).step(code);
            }
            return this.defined ? this.ok.step(code) : this.balanced(code);
        }

        private State balanced(int code) {
            this.labelStart._balanced = true;
            return this.nok.step(code);
        }
    }
}

