/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.packed;

import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.util.packed.BulkOperation;
import guideme.internal.shaded.lucene.util.packed.PackedInts;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

final class PackedWriter
extends PackedInts.Writer {
    boolean finished;
    final PackedInts.Format format;
    final BulkOperation encoder;
    final byte[] nextBlocks;
    final long[] nextValues;
    final int iterations;
    int off;
    int written;

    PackedWriter(PackedInts.Format format, DataOutput out, int valueCount, int bitsPerValue, int mem) {
        super(out, valueCount, bitsPerValue);
        this.format = format;
        this.encoder = BulkOperation.of(format, bitsPerValue);
        this.iterations = this.encoder.computeIterations(valueCount, mem);
        this.nextBlocks = new byte[this.iterations * this.encoder.byteBlockCount()];
        this.nextValues = new long[this.iterations * this.encoder.byteValueCount()];
        this.off = 0;
        this.written = 0;
        this.finished = false;
    }

    @Override
    public void add(long v) throws IOException {
        assert (PackedInts.unsignedBitsRequired(v) <= this.bitsPerValue);
        assert (!this.finished);
        if (this.valueCount != -1 && this.written >= this.valueCount) {
            throw new EOFException("Writing past end of stream");
        }
        this.nextValues[this.off++] = v;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        ++this.written;
    }

    @Override
    public void finish() throws IOException {
        assert (!this.finished);
        if (this.valueCount != -1) {
            while (this.written < this.valueCount) {
                this.add(0L);
            }
        }
        this.flush();
        this.finished = true;
    }

    private void flush() throws IOException {
        this.encoder.encode(this.nextValues, 0, this.nextBlocks, 0, this.iterations);
        int blockCount = (int)this.format.byteCount(2, this.off, this.bitsPerValue);
        this.out.writeBytes(this.nextBlocks, blockCount);
        Arrays.fill(this.nextValues, 0L);
        this.off = 0;
    }
}

