/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

import guideme.internal.shaded.lucene.internal.hppc.IntHashSet;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.InPlaceMergeSorter;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.Sorter;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import guideme.internal.shaded.lucene.util.automaton.TransitionAccessor;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class Automaton
implements Accountable,
TransitionAccessor {
    private int nextState;
    private int nextTransition;
    private int curState = -1;
    private int[] states;
    private final BitSet isAccept;
    private int[] transitions;
    private boolean deterministic = true;
    private final Sorter destMinMaxSorter = new InPlaceMergeSorter(){

        private void swapOne(int i, int j) {
            int x = Automaton.this.transitions[i];
            Automaton.this.transitions[i] = Automaton.this.transitions[j];
            Automaton.this.transitions[j] = x;
        }

        @Override
        protected void swap(int i, int j) {
            int iStart = 3 * i;
            int jStart = 3 * j;
            this.swapOne(iStart, jStart);
            this.swapOne(iStart + 1, jStart + 1);
            this.swapOne(iStart + 2, jStart + 2);
        }

        @Override
        protected int compare(int i, int j) {
            int iStart = 3 * i;
            int iDest = Automaton.this.transitions[iStart];
            int jStart = 3 * j;
            int jDest = Automaton.this.transitions[jStart];
            if (iDest < jDest) {
                return -1;
            }
            if (iDest > jDest) {
                return 1;
            }
            int iMin = Automaton.this.transitions[iStart + 1];
            int jMin = Automaton.this.transitions[jStart + 1];
            if (iMin < jMin) {
                return -1;
            }
            if (iMin > jMin) {
                return 1;
            }
            int iMax = Automaton.this.transitions[iStart + 2];
            int jMax = Automaton.this.transitions[jStart + 2];
            if (iMax < jMax) {
                return -1;
            }
            if (iMax > jMax) {
                return 1;
            }
            return 0;
        }
    };
    private final Sorter minMaxDestSorter = new InPlaceMergeSorter(){

        private void swapOne(int i, int j) {
            int x = Automaton.this.transitions[i];
            Automaton.this.transitions[i] = Automaton.this.transitions[j];
            Automaton.this.transitions[j] = x;
        }

        @Override
        protected void swap(int i, int j) {
            int iStart = 3 * i;
            int jStart = 3 * j;
            this.swapOne(iStart, jStart);
            this.swapOne(iStart + 1, jStart + 1);
            this.swapOne(iStart + 2, jStart + 2);
        }

        @Override
        protected int compare(int i, int j) {
            int iStart = 3 * i;
            int iMin = Automaton.this.transitions[iStart + 1];
            int jStart = 3 * j;
            int jMin = Automaton.this.transitions[jStart + 1];
            if (iMin < jMin) {
                return -1;
            }
            if (iMin > jMin) {
                return 1;
            }
            int iMax = Automaton.this.transitions[iStart + 2];
            int jMax = Automaton.this.transitions[jStart + 2];
            if (iMax < jMax) {
                return -1;
            }
            if (iMax > jMax) {
                return 1;
            }
            int iDest = Automaton.this.transitions[iStart];
            int jDest = Automaton.this.transitions[jStart];
            if (iDest < jDest) {
                return -1;
            }
            if (iDest > jDest) {
                return 1;
            }
            return 0;
        }
    };

    public Automaton() {
        this(2, 2);
    }

    public Automaton(int numStates, int numTransitions) {
        this.states = new int[numStates * 2];
        this.isAccept = new BitSet(numStates);
        this.transitions = new int[numTransitions * 3];
    }

    public int createState() {
        this.growStates();
        int state = this.nextState / 2;
        this.states[this.nextState] = -1;
        this.nextState += 2;
        return state;
    }

    public void setAccept(int state, boolean accept) {
        Objects.checkIndex(state, this.getNumStates());
        this.isAccept.set(state, accept);
    }

    BitSet getAcceptStates() {
        return this.isAccept;
    }

    public boolean isAccept(int state) {
        return this.isAccept.get(state);
    }

    public void addTransition(int source, int dest, int label) {
        this.addTransition(source, dest, label, label);
    }

    public void addTransition(int source, int dest, int min, int max) {
        assert (this.nextTransition % 3 == 0);
        int bounds = this.nextState / 2;
        Objects.checkIndex(source, bounds);
        Objects.checkIndex(dest, bounds);
        this.growTransitions();
        if (this.curState != source) {
            if (this.curState != -1) {
                this.finishCurrentState();
            }
            this.curState = source;
            if (this.states[2 * this.curState] != -1) {
                throw new IllegalStateException("from state (" + source + ") already had transitions added");
            }
            assert (this.states[2 * this.curState + 1] == 0);
            this.states[2 * this.curState] = this.nextTransition;
        }
        this.transitions[this.nextTransition++] = dest;
        this.transitions[this.nextTransition++] = min;
        this.transitions[this.nextTransition++] = max;
        int n = 2 * this.curState + 1;
        this.states[n] = this.states[n] + 1;
    }

    public void addEpsilon(int source, int dest) {
        Transition t = new Transition();
        int count = this.initTransition(dest, t);
        for (int i = 0; i < count; ++i) {
            this.getNextTransition(t);
            this.addTransition(source, t.dest, t.min, t.max);
        }
        if (this.isAccept(dest)) {
            this.setAccept(source, true);
        }
    }

    private void finishCurrentState() {
        int numTransitions = this.states[2 * this.curState + 1];
        assert (numTransitions > 0);
        int offset = this.states[2 * this.curState];
        int start = offset / 3;
        this.destMinMaxSorter.sort(start, start + numTransitions);
        int upto = 0;
        int min = -1;
        int max = -1;
        int dest = -1;
        for (int i = 0; i < numTransitions; ++i) {
            int tDest = this.transitions[offset + 3 * i];
            int tMin = this.transitions[offset + 3 * i + 1];
            int tMax = this.transitions[offset + 3 * i + 2];
            if (dest == tDest) {
                if (tMin <= max + 1) {
                    if (tMax <= max) continue;
                    max = tMax;
                    continue;
                }
                if (dest != -1) {
                    this.transitions[offset + 3 * upto] = dest;
                    this.transitions[offset + 3 * upto + 1] = min;
                    this.transitions[offset + 3 * upto + 2] = max;
                    ++upto;
                }
                min = tMin;
                max = tMax;
                continue;
            }
            if (dest != -1) {
                this.transitions[offset + 3 * upto] = dest;
                this.transitions[offset + 3 * upto + 1] = min;
                this.transitions[offset + 3 * upto + 2] = max;
                ++upto;
            }
            dest = tDest;
            min = tMin;
            max = tMax;
        }
        if (dest != -1) {
            this.transitions[offset + 3 * upto] = dest;
            this.transitions[offset + 3 * upto + 1] = min;
            this.transitions[offset + 3 * upto + 2] = max;
            ++upto;
        }
        this.nextTransition -= (numTransitions - upto) * 3;
        this.states[2 * this.curState + 1] = upto;
        this.minMaxDestSorter.sort(start, start + upto);
        if (this.deterministic && upto > 1) {
            int lastMax = this.transitions[offset + 2];
            for (int i = 1; i < upto; ++i) {
                min = this.transitions[offset + 3 * i + 1];
                if (min <= lastMax) {
                    this.deterministic = false;
                    break;
                }
                lastMax = this.transitions[offset + 3 * i + 2];
            }
        }
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void finishState() {
        if (this.curState != -1) {
            this.finishCurrentState();
            this.curState = -1;
        }
    }

    public int getNumStates() {
        return this.nextState / 2;
    }

    public int getNumTransitions() {
        return this.nextTransition / 3;
    }

    @Override
    public int getNumTransitions(int state) {
        assert (state >= 0);
        assert (state < this.getNumStates());
        int count = this.states[2 * state + 1];
        if (count == -1) {
            return 0;
        }
        return count;
    }

    private void growStates() {
        if (this.nextState + 2 > this.states.length) {
            this.states = ArrayUtil.grow(this.states, this.nextState + 2);
        }
    }

    private void growTransitions() {
        if (this.nextTransition + 3 > this.transitions.length) {
            this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 3);
        }
    }

    @Override
    public int initTransition(int state, Transition t) {
        assert (state < this.nextState / 2) : "state=" + state + " nextState=" + this.nextState;
        t.source = state;
        t.transitionUpto = this.states[2 * state];
        return this.getNumTransitions(state);
    }

    @Override
    public void getNextTransition(Transition t) {
        assert (t.transitionUpto + 3 - this.states[2 * t.source] <= 3 * this.states[2 * t.source + 1]);
        assert (this.transitionSorted(t));
        t.dest = this.transitions[t.transitionUpto++];
        t.min = this.transitions[t.transitionUpto++];
        t.max = this.transitions[t.transitionUpto++];
    }

    private boolean transitionSorted(Transition t) {
        int upto = t.transitionUpto;
        if (upto == this.states[2 * t.source]) {
            return true;
        }
        int nextDest = this.transitions[upto];
        int nextMin = this.transitions[upto + 1];
        int nextMax = this.transitions[upto + 2];
        if (nextMin > t.min) {
            return true;
        }
        if (nextMin < t.min) {
            return false;
        }
        if (nextMax > t.max) {
            return true;
        }
        if (nextMax < t.max) {
            return false;
        }
        if (nextDest > t.dest) {
            return true;
        }
        if (nextDest < t.dest) {
            return false;
        }
        return false;
    }

    public void getTransition(int state, int index, Transition t) {
        int i = this.states[2 * state] + 3 * index;
        t.source = state;
        t.dest = this.transitions[i++];
        t.min = this.transitions[i++];
        t.max = this.transitions[i++];
    }

    static void appendCharString(int c, StringBuilder b) {
        if (c >= 33 && c <= 126 && c != 92 && c != 34) {
            b.appendCodePoint(c);
        } else {
            b.append("\\\\U");
            String s = Integer.toHexString(c);
            if (c < 16) {
                b.append("0000000").append(s);
            } else if (c < 256) {
                b.append("000000").append(s);
            } else if (c < 4096) {
                b.append("00000").append(s);
            } else if (c < 65536) {
                b.append("0000").append(s);
            } else if (c < 0x100000) {
                b.append("000").append(s);
            } else if (c < 0x1000000) {
                b.append("00").append(s);
            } else if (c < 0x10000000) {
                b.append("0").append(s);
            } else {
                b.append(s);
            }
        }
    }

    public int[] getStartPoints() {
        IntHashSet pointset = new IntHashSet();
        pointset.add(0);
        for (int s = 0; s < this.nextState; s += 2) {
            int trans;
            int limit = trans + 3 * this.states[s + 1];
            for (trans = this.states[s]; trans < limit; trans += 3) {
                int min = this.transitions[trans + 1];
                int max = this.transitions[trans + 2];
                pointset.add(min);
                if (max >= 0x10FFFF) continue;
                pointset.add(max + 1);
            }
        }
        int[] points = pointset.toArray();
        Arrays.sort(points);
        return points;
    }

    public int next(Transition transition, int label) {
        return this.next(transition.source, transition.transitionUpto, label, transition);
    }

    private int next(int state, int fromTransitionIndex, int label, Transition transition) {
        assert (state >= 0);
        assert (label >= 0);
        int stateIndex = 2 * state;
        int firstTransitionIndex = this.states[stateIndex];
        int numTransitions = this.states[stateIndex + 1];
        int low = Math.max(fromTransitionIndex, 0);
        int high = numTransitions - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int transitionIndex = firstTransitionIndex + 3 * mid;
            int minLabel = this.transitions[transitionIndex + 1];
            if (minLabel > label) {
                high = mid - 1;
                continue;
            }
            int maxLabel = this.transitions[transitionIndex + 2];
            if (maxLabel < label) {
                low = mid + 1;
                continue;
            }
            int destState = this.transitions[transitionIndex];
            if (transition != null) {
                transition.dest = destState;
                transition.min = minLabel;
                transition.max = maxLabel;
                transition.transitionUpto = mid;
            }
            return destState;
        }
        int destState = -1;
        if (transition != null) {
            transition.dest = destState;
            transition.transitionUpto = low;
        }
        return destState;
    }

    @Override
    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf(this.states) + RamUsageEstimator.sizeOf(this.transitions) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)(this.isAccept.size() / 8) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 12L + 1L;
    }

    public static class Builder {
        private int nextState = 0;
        private final BitSet isAccept;
        private int[] transitions;
        private int nextTransition = 0;
        private final Sorter sorter = new InPlaceMergeSorter(){

            private void swapOne(int i, int j) {
                int x = transitions[i];
                transitions[i] = transitions[j];
                transitions[j] = x;
            }

            @Override
            protected void swap(int i, int j) {
                int iStart = 4 * i;
                int jStart = 4 * j;
                this.swapOne(iStart, jStart);
                this.swapOne(iStart + 1, jStart + 1);
                this.swapOne(iStart + 2, jStart + 2);
                this.swapOne(iStart + 3, jStart + 3);
            }

            @Override
            protected int compare(int i, int j) {
                int iStart = 4 * i;
                int iSrc = transitions[iStart];
                int jStart = 4 * j;
                int jSrc = transitions[jStart];
                if (iSrc < jSrc) {
                    return -1;
                }
                if (iSrc > jSrc) {
                    return 1;
                }
                int iMin = transitions[iStart + 2];
                int jMin = transitions[jStart + 2];
                if (iMin < jMin) {
                    return -1;
                }
                if (iMin > jMin) {
                    return 1;
                }
                int iMax = transitions[iStart + 3];
                int jMax = transitions[jStart + 3];
                if (iMax < jMax) {
                    return -1;
                }
                if (iMax > jMax) {
                    return 1;
                }
                int iDest = transitions[iStart + 1];
                int jDest = transitions[jStart + 1];
                if (iDest < jDest) {
                    return -1;
                }
                if (iDest > jDest) {
                    return 1;
                }
                return 0;
            }
        };

        public Builder() {
            this(16, 16);
        }

        public Builder(int numStates, int numTransitions) {
            this.isAccept = new BitSet(numStates);
            this.transitions = new int[numTransitions * 4];
        }

        public void addTransition(int source, int dest, int label) {
            this.addTransition(source, dest, label, label);
        }

        public void addTransition(int source, int dest, int min, int max) {
            if (this.transitions.length < this.nextTransition + 4) {
                this.transitions = ArrayUtil.grow(this.transitions, this.nextTransition + 4);
            }
            this.transitions[this.nextTransition++] = source;
            this.transitions[this.nextTransition++] = dest;
            this.transitions[this.nextTransition++] = min;
            this.transitions[this.nextTransition++] = max;
        }

        public Automaton finish() {
            int numStates = this.nextState;
            int numTransitions = this.nextTransition / 4;
            Automaton a = new Automaton(numStates, numTransitions);
            for (int state = 0; state < numStates; ++state) {
                a.createState();
                a.setAccept(state, this.isAccept(state));
            }
            this.sorter.sort(0, numTransitions);
            for (int upto = 0; upto < this.nextTransition; upto += 4) {
                a.addTransition(this.transitions[upto], this.transitions[upto + 1], this.transitions[upto + 2], this.transitions[upto + 3]);
            }
            a.finishState();
            return a;
        }

        public int createState() {
            return this.nextState++;
        }

        public void setAccept(int state, boolean accept) {
            Objects.checkIndex(state, this.getNumStates());
            this.isAccept.set(state, accept);
        }

        public boolean isAccept(int state) {
            return this.isAccept.get(state);
        }

        public int getNumStates() {
            return this.nextState;
        }

        public void copy(Automaton other) {
            int offset = this.getNumStates();
            int otherNumStates = other.getNumStates();
            this.copyStates(other);
            Transition t = new Transition();
            for (int s = 0; s < otherNumStates; ++s) {
                int count = other.initTransition(s, t);
                for (int i = 0; i < count; ++i) {
                    other.getNextTransition(t);
                    this.addTransition(offset + s, offset + t.dest, t.min, t.max);
                }
            }
        }

        public void copyStates(Automaton other) {
            int otherNumStates = other.getNumStates();
            for (int s = 0; s < otherNumStates; ++s) {
                int newState = this.createState();
                this.setAccept(newState, other.isAccept(s));
            }
        }
    }
}

