/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.FilterDirectory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.store.Lock;
import java.io.IOException;
import java.util.Collection;

public final class LockValidatingDirectoryWrapper
extends FilterDirectory {
    private final Lock writeLock;

    public LockValidatingDirectoryWrapper(Directory in, Lock writeLock) {
        super(in);
        this.writeLock = writeLock;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.writeLock.ensureValid();
        this.in.deleteFile(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.writeLock.ensureValid();
        return this.in.createOutput(name, context);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.writeLock.ensureValid();
        this.in.rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.writeLock.ensureValid();
        this.in.syncMetaData();
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.writeLock.ensureValid();
        this.in.sync(names);
    }
}

