/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

class TermsEnumIndex {
    static final TermsEnumIndex[] EMPTY_ARRAY = new TermsEnumIndex[0];
    final int subIndex;
    TermsEnum termsEnum;
    private BytesRef currentTerm;
    private long currentTermPrefix8;

    static long prefix8ToComparableUnsignedLong(BytesRef term) {
        int o;
        long l;
        if (term.length >= 8) {
            return BitUtil.VH_BE_LONG.get(term.bytes, term.offset);
        }
        if (4 <= term.length) {
            l = BitUtil.VH_BE_INT.get(term.bytes, term.offset);
            o = 4;
        } else {
            l = 0L;
            o = 0;
        }
        if (o + 2 <= term.length) {
            l = l << 16 | Short.toUnsignedLong(BitUtil.VH_BE_SHORT.get(term.bytes, term.offset + o));
            o += 2;
        }
        if (o < term.length) {
            l = l << 8 | Byte.toUnsignedLong(term.bytes[term.offset + o]);
        }
        return l <<= 8 - term.length << 3;
    }

    TermsEnumIndex(TermsEnum termsEnum, int subIndex) {
        this.termsEnum = termsEnum;
        this.subIndex = subIndex;
    }

    BytesRef term() {
        return this.currentTerm;
    }

    private void setTerm(BytesRef term) {
        this.currentTerm = term;
        this.currentTermPrefix8 = this.currentTerm == null ? 0L : TermsEnumIndex.prefix8ToComparableUnsignedLong(this.currentTerm);
    }

    BytesRef next() throws IOException {
        BytesRef term = this.termsEnum.next();
        this.setTerm(term);
        return term;
    }

    TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
        TermsEnum.SeekStatus status = this.termsEnum.seekCeil(term);
        if (status == TermsEnum.SeekStatus.END) {
            this.setTerm(null);
        } else {
            this.setTerm(this.termsEnum.term());
        }
        return status;
    }

    boolean seekExact(BytesRef term) throws IOException {
        boolean found = this.termsEnum.seekExact(term);
        if (found) {
            this.setTerm(this.termsEnum.term());
        } else {
            this.setTerm(null);
        }
        return found;
    }

    void reset(TermsEnumIndex tei) throws IOException {
        this.termsEnum = tei.termsEnum;
        this.currentTerm = tei.currentTerm;
        this.currentTermPrefix8 = tei.currentTermPrefix8;
    }

    int compareTermTo(TermsEnumIndex that) {
        if (this.currentTermPrefix8 != that.currentTermPrefix8) {
            int cmp = Long.compareUnsigned(this.currentTermPrefix8, that.currentTermPrefix8);
            assert (Integer.signum(cmp) == Integer.signum(Arrays.compareUnsigned(this.currentTerm.bytes, this.currentTerm.offset, this.currentTerm.offset + this.currentTerm.length, that.currentTerm.bytes, that.currentTerm.offset, that.currentTerm.offset + that.currentTerm.length)));
            return cmp;
        }
        return Arrays.compareUnsigned(this.currentTerm.bytes, this.currentTerm.offset, this.currentTerm.offset + this.currentTerm.length, that.currentTerm.bytes, that.currentTerm.offset, that.currentTerm.offset + that.currentTerm.length);
    }

    public String toString() {
        return Objects.toString(this.termsEnum);
    }

    boolean termEquals(TermState that) {
        if (this.currentTermPrefix8 != that.termPrefix8) {
            return false;
        }
        return Arrays.equals(this.currentTerm.bytes, this.currentTerm.offset, this.currentTerm.offset + this.currentTerm.length, that.term.bytes(), 0, that.term.length());
    }

    static class TermState {
        private final BytesRefBuilder term = new BytesRefBuilder();
        private long termPrefix8;

        TermState() {
        }

        void copyFrom(TermsEnumIndex tei) {
            this.term.copyBytes(tei.term());
            this.termPrefix8 = tei.currentTermPrefix8;
        }
    }
}

