/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.CompositeReader;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.DirectoryReader;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import guideme.internal.shaded.lucene.index.StoredFields;
import guideme.internal.shaded.lucene.index.Term;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseCompositeReader<R extends IndexReader>
extends CompositeReader {
    private final R[] subReaders;
    protected final Comparator<R> subReadersSorter;
    private final int[] starts;
    private final int maxDoc;
    private AtomicInteger numDocs = new AtomicInteger(-1);
    private final List<R> subReadersList;

    protected BaseCompositeReader(R[] subReaders, Comparator<R> subReadersSorter) throws IOException {
        if (subReadersSorter != null) {
            Arrays.sort(subReaders, subReadersSorter);
        }
        this.subReaders = subReaders;
        this.subReadersSorter = subReadersSorter;
        this.subReadersList = Collections.unmodifiableList(Arrays.asList(subReaders));
        this.starts = new int[subReaders.length + 1];
        long maxDoc = 0L;
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = (int)maxDoc;
            R r = subReaders[i];
            maxDoc += (long)((IndexReader)r).maxDoc();
            ((IndexReader)r).registerParentReader(this);
        }
        if (maxDoc > (long)IndexWriter.getActualMaxDocs()) {
            if (this instanceof DirectoryReader) {
                throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + maxDoc, Arrays.toString(subReaders));
            }
            throw new IllegalArgumentException("Too many documents: composite IndexReaders cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + maxDoc);
        }
        this.starts[subReaders.length] = this.maxDoc = Math.toIntExact(maxDoc);
    }

    @Override
    public final int numDocs() {
        int numDocs = this.numDocs.getOpaque();
        if (numDocs == -1) {
            numDocs = 0;
            for (R r : this.subReaders) {
                numDocs += ((IndexReader)r).numDocs();
            }
            assert (numDocs >= 0);
            this.numDocs.set(numDocs);
        }
        return numDocs;
    }

    @Override
    public final int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public final StoredFields storedFields() throws IOException {
        this.ensureOpen();
        final StoredFields[] subFields = new StoredFields[this.subReaders.length];
        return new StoredFields(){

            @Override
            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                int i = BaseCompositeReader.this.readerIndex(docID);
                if (subFields[i] == null) {
                    subFields[i] = ((IndexReader)BaseCompositeReader.this.subReaders[i]).storedFields();
                }
                subFields[i].document(docID - BaseCompositeReader.this.starts[i], visitor);
            }
        };
    }

    @Override
    public final int docFreq(Term term) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            int sub = ((IndexReader)this.subReaders[i]).docFreq(term);
            assert (sub >= 0);
            assert (sub <= ((IndexReader)this.subReaders[i]).getDocCount(term.field()));
            total += sub;
        }
        return total;
    }

    @Override
    public final int getDocCount(String field) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (R reader : this.subReaders) {
            int sub = ((IndexReader)reader).getDocCount(field);
            assert (sub >= 0);
            assert (sub <= ((IndexReader)reader).maxDoc());
            total += sub;
        }
        return total;
    }

    protected final int readerIndex(int docID) {
        if (docID < 0 || docID >= this.maxDoc) {
            throw new IllegalArgumentException("docID must be >= 0 and < maxDoc=" + this.maxDoc + " (got docID=" + docID + ")");
        }
        return ReaderUtil.subIndex(docID, this.starts);
    }

    protected final List<? extends R> getSequentialSubReaders() {
        return this.subReadersList;
    }
}

