/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis;

import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class WordlistLoader {
    public static CharArraySet getWordSet(Reader reader, String comment, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String word = null;
            while ((word = br.readLine()) != null) {
                if (word.startsWith(comment) || (word = word.trim()).isEmpty()) continue;
                result.add(word);
            }
        }
        return result;
    }

    public static CharArraySet getWordSet(Reader reader, String comment) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getWordSet(reader, comment, new CharArraySet(16, false)));
    }

    public static CharArraySet getWordSet(InputStream stream, String comment) throws IOException {
        return WordlistLoader.getWordSet(stream, StandardCharsets.UTF_8, comment);
    }

    public static CharArraySet getWordSet(InputStream stream, Charset charset, String comment) throws IOException {
        return WordlistLoader.getWordSet(IOUtils.getDecodingReader(stream, charset), comment);
    }

    public static CharArraySet getSnowballWordSet(Reader reader, CharArraySet result) throws IOException {
        try (BufferedReader br = WordlistLoader.getBufferedReader(reader);){
            String line = null;
            while ((line = br.readLine()) != null) {
                int comment = line.indexOf(124);
                if (comment >= 0) {
                    line = line.substring(0, comment);
                }
                String[] words = line.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    if (words[i].length() <= 0) continue;
                    result.add(words[i]);
                }
            }
        }
        return result;
    }

    public static CharArraySet getSnowballWordSet(Reader reader) throws IOException {
        return CharArraySet.unmodifiableSet(WordlistLoader.getSnowballWordSet(reader, new CharArraySet(16, false)));
    }

    public static CharArraySet getSnowballWordSet(InputStream stream) throws IOException {
        return WordlistLoader.getSnowballWordSet(stream, StandardCharsets.UTF_8);
    }

    public static CharArraySet getSnowballWordSet(InputStream stream, Charset charset) throws IOException {
        return WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(stream, charset));
    }

    private static BufferedReader getBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }
}

