/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.mdast.mdx;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.NamedCharacterEntities;
import java.util.HashMap;
import java.util.Map;

final class ParseEntities {
    private static final Map<Integer, String> characterReferenceInvalid;

    public static String parseEntities(String value) {
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < value.length(); ++index) {
            boolean terminated;
            CharRefType type;
            int start;
            char character = value.charAt(index);
            if (character != '&' || index + 1 >= value.length()) {
                result.append(character);
                continue;
            }
            char following = value.charAt(index + 1);
            if (following == '\t' || following == '\n' || following == '\f' || following == ' ' || following == '&' || following == '<') {
                result.append(character);
                continue;
            }
            int begin = start = index + 1;
            int end = start;
            if (following == '#') {
                if ((following = value.charAt(end = ++begin)) == 'X' || following == 'x') {
                    type = CharRefType.hexadecimal;
                    end = ++begin;
                } else {
                    type = CharRefType.decimal;
                }
            } else {
                type = CharRefType.named;
            }
            --end;
            StringBuilder charBuffer = new StringBuilder();
            while (++end < value.length() && type.test(following = value.charAt(end))) {
                charBuffer.append(following);
            }
            boolean consumeRef = terminated = end < value.length() && value.charAt(end) == ';';
            if (terminated) {
                ++end;
                if (type == CharRefType.named) {
                    String namedReference = NamedCharacterEntities.decodeNamedCharacterReference(charBuffer.toString());
                    if (namedReference != null) {
                        result.append(namedReference);
                    } else {
                        consumeRef = false;
                    }
                } else {
                    int referenceCode = Integer.parseInt(charBuffer, 0, charBuffer.length(), type == CharRefType.hexadecimal ? 16 : 10);
                    if (ParseEntities.prohibited(referenceCode)) {
                        result.append('\ufffd');
                    } else if (characterReferenceInvalid.containsKey(referenceCode)) {
                        result.append(characterReferenceInvalid.get(referenceCode));
                    } else {
                        result.appendCodePoint(referenceCode);
                    }
                }
            }
            if (!consumeRef) {
                result.append(value, start - 1, end);
            }
            index = end - 1;
        }
        return result.toString();
    }

    private static boolean prohibited(int code) {
        return code >= 55296 && code <= 57343 || code > 0x10FFFF;
    }

    static {
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        codes.put(0, "\ufffd");
        codes.put(128, "\u20ac");
        codes.put(130, "\u201a");
        codes.put(131, "\u0192");
        codes.put(132, "\u201e");
        codes.put(133, "\u2026");
        codes.put(134, "\u2020");
        codes.put(135, "\u2021");
        codes.put(136, "\u02c6");
        codes.put(137, "\u2030");
        codes.put(138, "\u0160");
        codes.put(139, "\u2039");
        codes.put(140, "\u0152");
        codes.put(142, "\u017d");
        codes.put(145, "\u2018");
        codes.put(146, "\u2019");
        codes.put(147, "\u201c");
        codes.put(148, "\u201d");
        codes.put(149, "\u2022");
        codes.put(150, "\u2013");
        codes.put(151, "\u2014");
        codes.put(152, "\u02dc");
        codes.put(153, "\u2122");
        codes.put(154, "\u0161");
        codes.put(155, "\u203a");
        codes.put(156, "\u0153");
        codes.put(158, "\u017e");
        codes.put(159, "\u0178");
        characterReferenceInvalid = Map.copyOf(codes);
    }

    static enum CharRefType {
        named{

            @Override
            boolean test(char ch) {
                return CharUtil.asciiAlphanumeric(ch);
            }
        }
        ,
        decimal{

            @Override
            boolean test(char ch) {
                return CharUtil.asciiDigit(ch);
            }
        }
        ,
        hexadecimal{

            @Override
            boolean test(char ch) {
                return CharUtil.asciiHexDigit(ch);
            }
        };


        abstract boolean test(char var1);
    }
}

