/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.siteexport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.JsonTreeWriter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import guideme.Guide;
import guideme.compiler.MdAstNodeAdapter;
import guideme.compiler.ParsedGuidePage;
import guideme.indices.PageIndex;
import guideme.internal.siteexport.model.ExportedPageJson;
import guideme.internal.siteexport.model.FluidInfoJson;
import guideme.internal.siteexport.model.ItemInfoJson;
import guideme.internal.siteexport.model.NavigationNodeJson;
import guideme.internal.siteexport.model.SiteExportJson;
import guideme.internal.util.Platform;
import guideme.libs.mdast.MdAstVisitor;
import guideme.libs.mdast.model.MdAstHeading;
import guideme.libs.mdast.model.MdAstNode;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteExportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(SiteExportWriter.class);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeHierarchyAdapter(MdAstNode.class, (Object)new MdAstNodeAdapter()).registerTypeAdapter(ResourceLocation.class, (Object)new WriteOnlyTypeAdapter<ResourceLocation>(){

        public void write(JsonWriter out, ResourceLocation value) throws IOException {
            out.value(value.toString());
        }
    }).registerTypeAdapter(Ingredient.class, (Object)new WriteOnlyTypeAdapter<Ingredient>(){

        public void write(JsonWriter out, Ingredient value) throws IOException {
            out.beginArray();
            for (ItemStack item : value.getItems()) {
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
                out.value(itemId.toString());
            }
            out.endArray();
        }
    }).registerTypeHierarchyAdapter(Item.class, (Object)new WriteOnlyTypeAdapter<Item>(){

        public void write(JsonWriter out, Item value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(BuiltInRegistries.ITEM.getKey((Object)value).toString());
            }
        }
    }).registerTypeHierarchyAdapter(Fluid.class, (Object)new WriteOnlyTypeAdapter<Fluid>(){

        public void write(JsonWriter out, Fluid value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(BuiltInRegistries.FLUID.getKey((Object)value).toString());
            }
        }
    }).registerTypeAdapter(ItemStack.class, (Object)new WriteOnlyTypeAdapter<ItemStack>(){

        public void write(JsonWriter out, ItemStack value) throws IOException {
            if (value == null || value.isEmpty()) {
                out.nullValue();
            } else {
                out.value(BuiltInRegistries.ITEM.getKey((Object)value.getItem()).toString());
            }
        }
    }).registerTypeAdapter(Boolean.class, (Object)new WriteOnlyTypeAdapter<Boolean>(){

        public void write(JsonWriter out, Boolean value) throws IOException {
            out.value(value.booleanValue());
        }
    }).create();
    private final SiteExportJson siteExport = new SiteExportJson();

    public SiteExportWriter(Guide guide) {
        this.siteExport.defaultNamespace = guide.getDefaultNamespace();
        this.siteExport.navigationRootNodes = guide.getNavigationTree().getRootNodes().stream().map(NavigationNodeJson::of).toList();
    }

    public void addItem(String id, ItemStack stack, String iconPath) {
        ItemInfoJson itemInfo = new ItemInfoJson();
        itemInfo.id = id;
        itemInfo.icon = iconPath;
        itemInfo.displayName = stack.getHoverName().getString();
        itemInfo.rarity = stack.getRarity().name().toLowerCase(Locale.ROOT);
        this.siteExport.items.put(itemInfo.id, itemInfo);
    }

    public void addFluid(String id, FluidStack fluid, String iconPath) {
        FluidInfoJson fluidInfo = new FluidInfoJson();
        fluidInfo.id = id;
        fluidInfo.icon = iconPath;
        fluidInfo.displayName = fluid.getHoverName().getString();
        this.siteExport.fluids.put(fluidInfo.id, fluidInfo);
    }

    public void addRecipe(ResourceLocation id, CraftingRecipe recipe) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            fields.put("shapeless", false);
            fields.put("width", shapedRecipe.getWidth());
            fields.put("height", shapedRecipe.getHeight());
        } else {
            fields.put("shapeless", true);
        }
        ItemStack resultItem = recipe.getResultItem(null);
        fields.put("resultItem", resultItem);
        fields.put("resultCount", resultItem.getCount());
        fields.put("ingredients", recipe.getIngredients());
        this.addRecipe(id, (Recipe<?>)recipe, (Map<String, Object>)fields);
    }

    public void addRecipe(ResourceLocation id, AbstractCookingRecipe recipe) {
        this.addRecipe(id, (Recipe<?>)recipe, Map.of("resultItem", recipe.getResultItem(null), "ingredient", recipe.getIngredients().get(0)));
    }

    public void addRecipe(ResourceLocation id, SmithingTransformRecipe recipe) {
        this.addRecipe(id, (Recipe<?>)recipe, (Map<String, Object>)Map.of("resultItem", recipe.getResultItem(null), "base", recipe.base, "addition", recipe.addition, "template", recipe.template));
    }

    public void addRecipe(ResourceLocation id, SmithingTrimRecipe recipe) {
        this.addRecipe(id, (Recipe<?>)recipe, (Map<String, Object>)Map.of("base", recipe.base, "addition", recipe.addition, "template", recipe.template));
    }

    public void addRecipe(ResourceLocation id, StonecutterRecipe recipe) {
        this.addRecipe(id, (Recipe<?>)recipe, Map.of("resultItem", recipe.getResultItem(null), "ingredient", recipe.getIngredients().get(0)));
    }

    public void addRecipe(ResourceLocation id, Recipe<?> recipe, Map<String, Object> element) {
        JsonElement jsonElement = GSON.toJsonTree(element);
        String type = BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.getType()).toString();
        jsonElement.getAsJsonObject().addProperty("type", type);
        if (this.siteExport.recipes.put(id.toString(), jsonElement) != null) {
            throw new RuntimeException("Duplicate recipe id " + String.valueOf(id));
        }
    }

    public void addModData(String key, Object data) {
        this.siteExport.modData.put(key, data);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(bout);
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            GSON.toJson((Object)this.siteExport, (Appendable)writer);
        }
        return bout.toByteArray();
    }

    public void addPage(ParsedGuidePage page) {
        ExportedPageJson exportedPage = new ExportedPageJson();
        if (page.getFrontmatter().navigationEntry() != null) {
            exportedPage.title = page.getFrontmatter().navigationEntry().title();
        } else {
            exportedPage.title = this.extractPageTitle(page);
            if (exportedPage.title.isEmpty()) {
                LOG.warn("Unable to determine page title for {}: {}", (Object)page.getId(), (Object)exportedPage.title);
            }
        }
        exportedPage.astRoot = page.getAstRoot();
        exportedPage.frontmatter.putAll(page.getFrontmatter().additionalProperties());
        this.siteExport.pages.put(page.getId(), exportedPage);
    }

    private String extractPageTitle(ParsedGuidePage page) {
        final StringBuilder pageTitle = new StringBuilder();
        page.getAstRoot().visit(new MdAstVisitor(){

            @Override
            public MdAstVisitor.Result beforeNode(MdAstNode node) {
                if (node instanceof MdAstHeading) {
                    MdAstHeading heading = (MdAstHeading)node;
                    if (heading.depth == 1) {
                        pageTitle.append(heading.toText());
                    }
                    return MdAstVisitor.Result.STOP;
                }
                return MdAstVisitor.Result.CONTINUE;
            }
        });
        return pageTitle.toString();
    }

    public String addItem(ItemStack stack) {
        MessageDigest digest;
        String itemId = stack.getItem().builtInRegistryHolder().key().location().toString().replace(':', '-');
        if (stack.getComponentsPatch().isEmpty()) {
            return itemId;
        }
        CompoundTag serializedTag = (CompoundTag)stack.save((HolderLookup.Provider)Platform.getClientRegistryAccess());
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (DataOutputStream out = new DataOutputStream(new DigestOutputStream(OutputStream.nullOutputStream(), digest));){
            NbtIo.write((CompoundTag)serializedTag, (DataOutput)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return itemId + "-" + HexFormat.of().formatHex(digest.digest());
    }

    public void addIndex(Guide guide, Class<? extends PageIndex> indexClass) {
        try (JsonTreeWriter jsonWriter = new JsonTreeWriter();){
            PageIndex index = guide.getIndex(indexClass);
            index.export((JsonWriter)jsonWriter);
            this.siteExport.pageIndices.put(indexClass.getName(), jsonWriter.get());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static abstract class WriteOnlyTypeAdapter<T>
    extends TypeAdapter<T> {
        private WriteOnlyTypeAdapter() {
        }

        public T read(JsonReader in) {
            throw new UnsupportedOperationException();
        }
    }
}

