/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class HnswUtil {
    private HnswUtil() {
    }

    static List<Component> components(HnswGraph hnsw, int level, FixedBitSet notFullyConnected, int maxConn) throws IOException {
        int entryPoint;
        ArrayList<Component> components = new ArrayList<Component>();
        FixedBitSet connectedNodes = new FixedBitSet(hnsw.size());
        assert (hnsw.size() == hnsw.getNodesOnLevel(0).size());
        int total = 0;
        if (level >= hnsw.numLevels()) {
            throw new IllegalArgumentException("Level " + level + " too large for graph with " + hnsw.numLevels() + " levels");
        }
        HnswGraph.NodesIterator entryPoints = level == hnsw.numLevels() - 1 ? new HnswGraph.ArrayNodesIterator(new int[]{hnsw.entryNode()}, 1) : hnsw.getNodesOnLevel(level + 1);
        while (entryPoints.hasNext()) {
            entryPoint = entryPoints.nextInt();
            Component component = HnswUtil.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, entryPoint);
            total += component.size();
        }
        entryPoint = notFullyConnected != null ? notFullyConnected.nextSetBit(0) : connectedNodes.nextSetBit(0);
        components.add(new Component(entryPoint, total));
        if (level == 0) {
            int nextClear = HnswUtil.nextClearBit(connectedNodes, 0);
            while (nextClear != Integer.MAX_VALUE) {
                Component component = HnswUtil.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, nextClear);
                assert (component.size() > 0);
                components.add(component);
                total += component.size();
                nextClear = HnswUtil.nextClearBit(connectedNodes, component.start());
            }
        } else {
            HnswGraph.NodesIterator nodes = hnsw.getNodesOnLevel(level);
            while (nodes.hasNext()) {
                int nextClear = nodes.nextInt();
                if (connectedNodes.get(nextClear)) continue;
                Component component = HnswUtil.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, nextClear);
                assert (component.size() > 0);
                components.add(component);
                total += component.size();
            }
        }
        assert (total == hnsw.getNodesOnLevel(level).size()) : "total=" + total + " level nodes on level " + level + " = " + hnsw.getNodesOnLevel(level).size();
        return components;
    }

    private static Component markRooted(HnswGraph hnswGraph, int level, FixedBitSet connectedNodes, FixedBitSet notFullyConnected, int maxConn, int entryPoint) throws IOException {
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(entryPoint);
        int count = 0;
        while (!stack.isEmpty()) {
            int friendOrd;
            int node = (Integer)stack.pop();
            if (connectedNodes.get(node)) continue;
            ++count;
            connectedNodes.set(node);
            hnswGraph.seek(level, node);
            int friendCount = 0;
            while ((friendOrd = hnswGraph.nextNeighbor()) != Integer.MAX_VALUE) {
                ++friendCount;
                stack.push(friendOrd);
            }
            if (friendCount >= maxConn || notFullyConnected == null) continue;
            notFullyConnected.set(node);
        }
        return new Component(entryPoint, count);
    }

    private static int nextClearBit(FixedBitSet bits, int index) {
        long[] barray = bits.getBits();
        assert (index >= 0 && index < bits.length()) : "index=" + index + ", numBits=" + bits.length();
        int i = index >> 6;
        long word = barray[i] >> index ^ 0xFFFFFFFFFFFFFFFFL;
        int next = Integer.MAX_VALUE;
        if (word != 0L) {
            next = index + Long.numberOfTrailingZeros(word);
        } else {
            while (++i < barray.length) {
                word = barray[i] ^ 0xFFFFFFFFFFFFFFFFL;
                if (word == 0L) continue;
                next = (i << 6) + Long.numberOfTrailingZeros(word);
                break;
            }
        }
        if (next >= bits.length()) {
            return Integer.MAX_VALUE;
        }
        return next;
    }

    record Component(int start, int size) {
    }
}

