/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.fst;

import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.fst.FST;
import guideme.internal.shaded.lucene.util.fst.FSTEnum;
import java.io.IOException;

public final class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    private final BytesRef current = new BytesRef(10);
    private final InputOutput<T> result = new InputOutput();

    public BytesRefFSTEnum(FST<T> fst) {
        super(fst);
        this.result.input = this.current;
        this.current.offset = 1;
    }

    public InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    @Override
    protected void setCurrentLabel(int label) {
        this.current.bytes[this.upto] = (byte)label;
    }

    @Override
    protected void grow() {
        this.current.bytes = ArrayUtil.grow(this.current.bytes, this.upto + 1);
    }

    private InputOutput<T> setResult() {
        if (this.upto == 0) {
            return null;
        }
        this.current.length = this.upto - 1;
        this.result.output = this.output[this.upto];
        return this.result;
    }

    public static class InputOutput<T> {
        public BytesRef input;
        public T output;
    }
}

