/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.search.DocIdSet;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.BitSet;
import guideme.internal.shaded.lucene.util.BitSetIterator;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;

public class BitDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitDocIdSet.class);
    private final BitSet set;
    private final long cost;

    public BitDocIdSet(BitSet set, long cost) {
        if (cost < 0L) {
            throw new IllegalArgumentException("cost must be >= 0, got " + cost);
        }
        this.set = set;
        this.cost = cost;
    }

    @Override
    public DocIdSetIterator iterator() {
        return new BitSetIterator(this.set, this.cost);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.set.ramBytesUsed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(set=" + String.valueOf(this.set) + ",cost=" + this.cost + ")";
    }
}

