/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.util.BytesRef;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;

public final class TermStatistics
extends Record {
    private final BytesRef term;
    private final long docFreq;
    private final long totalTermFreq;

    public TermStatistics(BytesRef term, long docFreq, long totalTermFreq) {
        Objects.requireNonNull(term);
        if (docFreq <= 0L) {
            throw new IllegalArgumentException("docFreq must be positive, docFreq: " + docFreq);
        }
        if (totalTermFreq <= 0L) {
            throw new IllegalArgumentException("totalTermFreq must be positive, totalTermFreq: " + totalTermFreq);
        }
        if (totalTermFreq < docFreq) {
            throw new IllegalArgumentException("totalTermFreq must be at least docFreq, totalTermFreq: " + totalTermFreq + ", docFreq: " + docFreq);
        }
        this.term = term;
        this.docFreq = docFreq;
        this.totalTermFreq = totalTermFreq;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TermStatistics.class, "term;docFreq;totalTermFreq", "term", "docFreq", "totalTermFreq"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TermStatistics.class, "term;docFreq;totalTermFreq", "term", "docFreq", "totalTermFreq"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TermStatistics.class, "term;docFreq;totalTermFreq", "term", "docFreq", "totalTermFreq"}, this, o);
    }

    public long docFreq() {
        return this.docFreq;
    }

    public long totalTermFreq() {
        return this.totalTermFreq;
    }
}

