/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;

public abstract class FieldComparator<T> {
    public int compareValues(T first, T second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return ((Comparable)first).compareTo(second);
    }

    public void disableSkipping() {
    }

    public static class TermValComparator
    extends FieldComparator<BytesRef> {
        private final BytesRef[] values;
        private final BytesRefBuilder[] tempBRs;
        private final String field;
        private final int missingSortCmp;

        public TermValComparator(int numHits, String field, boolean sortMissingLast) {
            this.values = new BytesRef[numHits];
            this.tempBRs = new BytesRefBuilder[numHits];
            this.field = field;
            this.missingSortCmp = sortMissingLast ? 1 : -1;
        }

        @Override
        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return this.missingSortCmp;
            }
            if (val2 == null) {
                return -this.missingSortCmp;
            }
            return val1.compareTo(val2);
        }
    }

    public static final class RelevanceComparator
    extends FieldComparator<Float> {
        private final float[] scores;

        public RelevanceComparator(int numHits) {
            this.scores = new float[numHits];
        }

        @Override
        public int compareValues(Float first, Float second) {
            return second.compareTo(first);
        }
    }
}

