/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.BufferAllocationException;
import guideme.internal.shaded.lucene.internal.hppc.HashContainers;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Iterator;

public class LongIntHashMap
implements Accountable,
Cloneable,
Iterable<LongIntCursor> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongIntHashMap.class);
    public long[] keys;
    public int[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public LongIntHashMap() {
        this(4);
    }

    public LongIntHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongIntHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public int put(long key, int value) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0L) {
            int previousValue = this.hasEmptyKey ? this.values[mask + 1] : 0;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                int previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    public int get(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongIntCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongIntHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongIntHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongIntCursor c : other) {
            long key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            int[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public Iterator<LongIntCursor> iterator() {
        return new EntryIterator();
    }

    public LongIntHashMap clone() {
        try {
            LongIntHashMap cloned = (LongIntHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (int[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongIntCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, int[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        int[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            long existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        long[] prevKeys = this.keys;
        int[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new int[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, int pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        int[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    public static final class LongIntCursor {
        public int index;
        public long key;
        public int value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    private final class EntryIterator
    extends AbstractIterator<LongIntCursor> {
        private final LongIntCursor cursor = new LongIntCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongIntHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongIntHashMap.this.mask;
        }

        @Override
        protected LongIntCursor fetch() {
            int mask = LongIntHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongIntHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = LongIntHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0L;
                this.cursor.value = LongIntHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (LongIntCursor)this.done();
        }
    }
}

