/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import java.io.IOException;
import java.util.List;

public abstract class ByteVectorValues
extends KnnVectorValues {
    protected ByteVectorValues() {
    }

    public abstract byte[] vectorValue(int var1) throws IOException;

    public abstract ByteVectorValues copy() throws IOException;

    @Override
    public VectorEncoding getEncoding() {
        return VectorEncoding.BYTE;
    }

    public static ByteVectorValues fromBytes(final List<byte[]> vectors, final int dim) {
        return new ByteVectorValues(){

            @Override
            public int size() {
                return vectors.size();
            }

            @Override
            public int dimension() {
                return dim;
            }

            @Override
            public byte[] vectorValue(int targetOrd) {
                return (byte[])vectors.get(targetOrd);
            }

            @Override
            public ByteVectorValues copy() {
                return this;
            }

            @Override
            public KnnVectorValues.DocIndexIterator iterator() {
                return this.createDenseIterator();
            }
        };
    }
}

