/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.index.IndexableField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Document
implements Iterable<IndexableField> {
    private final List<IndexableField> fields = new ArrayList<IndexableField>();
    private static final String[] NO_STRINGS = new String[0];

    @Override
    public Iterator<IndexableField> iterator() {
        return this.fields.iterator();
    }

    public final void add(IndexableField field) {
        this.fields.add(field);
    }

    public final String get(String name) {
        for (IndexableField field : this.fields) {
            if (!field.name().equals(name) || field.stringValue() == null) continue;
            return field.stringValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            IndexableField field = this.fields.get(i);
            buffer.append(field.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

