/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.es;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.es.SpanishLightStemFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.snowball.SnowballFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class SpanishAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;

    public SpanishAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public SpanishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public SpanishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SpanishLightStemFilter(result);
        return new Analyzer.TokenStreamComponents(source, (TokenStream)result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.requireResourceNonNull(SnowballFilter.class.getResourceAsStream("spanish_stop.txt"), "spanish_stop.txt"));
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

