/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ar;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.LowerCaseFilter;
import guideme.internal.shaded.lucene.analysis.StopFilter;
import guideme.internal.shaded.lucene.analysis.StopwordAnalyzerBase;
import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.analysis.ar.ArabicNormalizationFilter;
import guideme.internal.shaded.lucene.analysis.ar.ArabicStemFilter;
import guideme.internal.shaded.lucene.analysis.core.DecimalDigitFilter;
import guideme.internal.shaded.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import guideme.internal.shaded.lucene.analysis.standard.StandardTokenizer;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class ArabicAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;

    public ArabicAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public ArabicAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        result = new DecimalDigitFilter(result);
        result = new StopFilter(result, this.stopwords);
        result = new ArabicNormalizationFilter(result);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)new ArabicStemFilter(result));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new LowerCaseFilter(in);
        result = new DecimalDigitFilter(result);
        result = new ArabicNormalizationFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getWordSet(IOUtils.requireResourceNonNull(ArabicAnalyzer.class.getResourceAsStream("stopwords.txt"), "stopwords.txt"), "#");
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Unable to load default stopword set", ex);
            }
        }
    }
}

