/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import guideme.color.ColorValue;
import guideme.color.LightDarkMode;
import guideme.color.SymbolicColor;
import guideme.document.LytPoint;
import guideme.document.LytRect;
import guideme.document.LytSize;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBox;
import guideme.document.block.LytVBox;
import guideme.document.block.LytVisitor;
import guideme.document.interaction.ContentTooltip;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.InteractiveElement;
import guideme.document.interaction.LytWidget;
import guideme.extensions.ExtensionCollection;
import guideme.internal.GuideMEClient;
import guideme.internal.screen.GuideIconButton;
import guideme.internal.siteexport.OffScreenRenderer;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import guideme.scene.CameraSettings;
import guideme.scene.GuidebookLevelRenderer;
import guideme.scene.GuidebookScene;
import guideme.scene.ImplicitAnnotationStrategy;
import guideme.scene.SavedCameraSettings;
import guideme.scene.annotation.InWorldAnnotation;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.OverlayAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import guideme.ui.GuideUiHost;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector2i;
import org.joml.Vector4f;

public class LytGuidebookScene
extends LytBox {
    @Nullable
    private GuidebookScene scene;
    private boolean interactive;
    @Nullable
    private ColorValue background;
    private final ExtensionCollection extensions;
    private boolean fullWidth;
    private final LytVBox toolbar = new LytVBox();
    private final Viewport viewport = new Viewport();
    private SavedCameraSettings initialCameraSettings = new SavedCameraSettings();
    private final LytWidget hideAnnotationsButton;
    private final LytWidget zoomInButton;
    private final LytWidget zoomOutButton;
    private final LytWidget resetViewButton;

    public LytGuidebookScene(ExtensionCollection extensions) {
        this.extensions = extensions;
        this.setPadding(5);
        this.append(this.viewport);
        this.hideAnnotationsButton = new LytWidget((AbstractWidget)new GuideIconButton(0, 0, GuideIconButton.Role.HIDE_ANNOTATIONS, btn -> {
            this.viewport.setHideAnnotations(!this.viewport.isHideAnnotations());
            if (this.viewport.isHideAnnotations()) {
                btn.setRole(GuideIconButton.Role.SHOW_ANNOTATIONS);
            } else {
                btn.setRole(GuideIconButton.Role.HIDE_ANNOTATIONS);
            }
        }));
        this.zoomInButton = new LytWidget((AbstractWidget)new GuideIconButton(0, 0, GuideIconButton.Role.ZOOM_IN, () -> {
            if (this.scene != null) {
                float currentZoom = this.scene.getCameraSettings().getZoom();
                currentZoom = Mth.clamp((float)(currentZoom + 0.5f), (float)0.1f, (float)8.0f);
                this.scene.getCameraSettings().setZoom(currentZoom);
            }
        }));
        this.zoomOutButton = new LytWidget((AbstractWidget)new GuideIconButton(0, 0, GuideIconButton.Role.ZOOM_OUT, () -> {
            if (this.scene != null) {
                float currentZoom = this.scene.getCameraSettings().getZoom();
                currentZoom = Mth.clamp((float)(currentZoom - 0.5f), (float)0.1f, (float)8.0f);
                this.scene.getCameraSettings().setZoom(currentZoom);
            }
        }));
        this.resetViewButton = new LytWidget((AbstractWidget)new GuideIconButton(0, 0, GuideIconButton.Role.RESET_VIEW, () -> {
            if (this.scene != null) {
                this.scene.getCameraSettings().restore(this.initialCameraSettings);
            }
        }));
    }

    @Nullable
    public GuidebookScene getScene() {
        return this.scene;
    }

    public void setScene(@Nullable GuidebookScene scene) {
        this.scene = scene;
        this.viewport.setHoveredAnnotation(null);
        this.initialCameraSettings = scene != null ? scene.getCameraSettings().save() : new SavedCameraSettings();
        this.updateToolbar();
    }

    private void updateToolbar() {
        this.toolbar.clearContent();
        if (this.scene == null) {
            return;
        }
        if (!this.scene.getInWorldAnnotations().isEmpty() || !this.scene.getOverlayAnnotations().isEmpty()) {
            this.toolbar.append(this.hideAnnotationsButton);
        }
        this.toolbar.append(this.zoomInButton);
        this.toolbar.append(this.zoomOutButton);
        this.toolbar.append(this.resetViewButton);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytSize prefSceneSize = this.viewport.getPreferredSize();
        prefSceneSize = new LytSize(prefSceneSize.width() + this.paddingLeft + this.paddingRight, prefSceneSize.height() + this.paddingTop + this.paddingBottom);
        int sceneWidth = this.fullWidth ? availableWidth : Math.min(prefSceneSize.width(), availableWidth);
        int sceneHeight = prefSceneSize.height();
        LytRect toolbarBounds = this.toolbar.layout(context, x, y, 0);
        if (sceneWidth + toolbarBounds.width() > availableWidth) {
            sceneWidth = availableWidth - toolbarBounds.width();
        }
        toolbarBounds = this.toolbar.layout(context, x + sceneWidth, y, availableWidth - sceneWidth);
        if (sceneWidth < 10) {
            sceneWidth = 10;
        }
        LytRect viewportBounds = new LytRect(x, y, sceneWidth, sceneHeight);
        this.viewport.setBounds(viewportBounds);
        return LytRect.union(viewportBounds, toolbarBounds);
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
        if (interactive) {
            this.append(this.toolbar);
        } else {
            this.removeChild(this.toolbar);
        }
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setBackground(ColorValue background) {
        this.background = background;
    }

    @Override
    public boolean isFullWidth() {
        return this.fullWidth;
    }

    @Override
    public void setFullWidth(boolean fullWidth) {
        this.fullWidth = fullWidth;
    }

    public LytSize getPreferredSize() {
        return this.viewport.getPreferredSize();
    }

    public byte[] exportAsPng(float scale, boolean hideAnnotations) {
        if (this.scene == null) {
            return null;
        }
        LytSize prefSize = this.viewport.getPreferredSize();
        if (prefSize.width() <= 0 || prefSize.height() <= 0) {
            return null;
        }
        int width = (int)Math.max(1.0f, (float)prefSize.width() * scale);
        int height = (int)Math.max(1.0f, (float)prefSize.height() * scale);
        try (OffScreenRenderer osr = new OffScreenRenderer(width, height);){
            byte[] byArray = osr.captureAsPng(() -> {
                GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
                this.scene.getCameraSettings().setViewportSize(prefSize);
                List<InWorldAnnotation> annotations = hideAnnotations ? Collections.emptyList() : this.scene.getInWorldAnnotations();
                renderer.render(this.scene.getLevel(), this.scene.getCameraSettings(), annotations, LightDarkMode.LIGHT_MODE);
            });
            return byArray;
        }
    }

    @Override
    protected LytVisitor.Result visitChildren(LytVisitor visitor, boolean includeOutOfTreeContent) {
        LytVisitor.Result result = super.visitChildren(visitor, includeOutOfTreeContent);
        if (result == LytVisitor.Result.STOP) {
            return result;
        }
        if (includeOutOfTreeContent && this.scene != null) {
            if (this.visitAnnotations(this.scene.getInWorldAnnotations(), visitor) == LytVisitor.Result.STOP) {
                return LytVisitor.Result.STOP;
            }
            if (this.visitAnnotations(this.scene.getOverlayAnnotations(), visitor) == LytVisitor.Result.STOP) {
                return LytVisitor.Result.STOP;
            }
        }
        return result;
    }

    private LytVisitor.Result visitAnnotations(Collection<? extends SceneAnnotation> annotations, LytVisitor visitor) {
        for (SceneAnnotation sceneAnnotation : annotations) {
            ContentTooltip contentTooltip;
            GuideTooltip guideTooltip = sceneAnnotation.getTooltip();
            if (!(guideTooltip instanceof ContentTooltip) || (contentTooltip = (ContentTooltip)guideTooltip).getContent().visit(visitor, true) != LytVisitor.Result.STOP) continue;
            return LytVisitor.Result.STOP;
        }
        return LytVisitor.Result.CONTINUE;
    }

    class Viewport
    extends LytBlock
    implements InteractiveElement {
        @Nullable
        private SceneAnnotation hoveredAnnotation;
        private boolean hideAnnotations;
        private boolean transientHoveredAnnotation;
        private int buttonDown;
        private Vector2i pointDown;
        private float initialRotY;
        private float initialRotX;
        private float initialTransX;
        private float initialTransY;

        Viewport() {
        }

        @Override
        protected LytRect computeLayout(LayoutContext context, int x, int y, int availableWidth) {
            return this.bounds;
        }

        @Override
        protected void onLayoutMoved(int deltaX, int deltaY) {
        }

        @Override
        public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        }

        @Override
        public void render(RenderContext context) {
            List<InWorldAnnotation> inWorldAnnotations;
            if (LytGuidebookScene.this.background != null) {
                context.fillRect(this.bounds, LytGuidebookScene.this.background);
            }
            if (LytGuidebookScene.this.scene == null) {
                return;
            }
            Window window = Minecraft.getInstance().getWindow();
            context.pushScissor(this.bounds);
            LytRect viewport = this.bounds.transform(context.poseStack().last().pose());
            RenderSystem.viewport((int)((int)((double)viewport.x() * window.getGuiScale())), (int)((int)((double)window.getHeight() - (double)viewport.bottom() * window.getGuiScale())), (int)((int)((double)viewport.width() * window.getGuiScale())), (int)((int)((double)viewport.height() * window.getGuiScale())));
            GuidebookLevelRenderer renderer = GuidebookLevelRenderer.getInstance();
            if (this.hideAnnotations) {
                SceneAnnotation sceneAnnotation;
                if (this.transientHoveredAnnotation && (sceneAnnotation = this.hoveredAnnotation) instanceof InWorldAnnotation) {
                    InWorldAnnotation hoveredInWorldAnnotation = (InWorldAnnotation)sceneAnnotation;
                    inWorldAnnotations = Collections.singletonList(hoveredInWorldAnnotation);
                } else {
                    inWorldAnnotations = Collections.emptyList();
                }
            } else {
                inWorldAnnotations = LytGuidebookScene.this.scene.getInWorldAnnotations();
            }
            renderer.render(LytGuidebookScene.this.scene.getLevel(), LytGuidebookScene.this.scene.getCameraSettings(), inWorldAnnotations, context.lightDarkMode());
            this.renderDebugCrosshairs();
            RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
            if (!this.hideAnnotations) {
                this.renderOverlayAnnotations(LytGuidebookScene.this.scene, context);
            }
            context.popScissor();
        }

        private void renderDebugCrosshairs() {
            if (!GuideMEClient.instance().isShowDebugGuiOverlays()) {
                return;
            }
            RenderSystem.renderCrosshair((int)16);
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)LytGuidebookScene.this.scene.getCameraSettings().getProjectionMatrix(), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.pushMatrix();
            modelViewStack.identity();
            modelViewStack.mul((Matrix4fc)LytGuidebookScene.this.scene.getCameraSettings().getViewMatrix());
            RenderSystem.applyModelViewMatrix();
            RenderSystem.renderCrosshair((int)2);
            modelViewStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.restoreProjectionMatrix();
        }

        @Override
        public Optional<GuideTooltip> getTooltip(float x, float y) {
            BlockHitResult hitResult;
            if (LytGuidebookScene.this.scene == null || this.bounds.isEmpty()) {
                this.setHoveredAnnotation(null);
                return Optional.empty();
            }
            LytPoint docPoint = new LytPoint(x, y);
            SceneAnnotation annotation = null;
            if (!this.hideAnnotations) {
                if (this.hoveredAnnotation != null && this.transientHoveredAnnotation) {
                    LytGuidebookScene.this.scene.removeAnnotation(this.hoveredAnnotation);
                    annotation = LytGuidebookScene.this.scene.pickAnnotation(docPoint, this.bounds, SceneAnnotation::hasTooltip);
                    LytGuidebookScene.this.scene.addAnnotation(this.hoveredAnnotation);
                } else {
                    annotation = LytGuidebookScene.this.scene.pickAnnotation(docPoint, this.bounds, SceneAnnotation::hasTooltip);
                }
                if (annotation != null && annotation.getTooltip() != null) {
                    this.setHoveredAnnotation(annotation);
                    return Optional.of(annotation.getTooltip());
                }
            }
            if ((hitResult = LytGuidebookScene.this.scene.pickBlock(docPoint, this.bounds)).getType() == HitResult.Type.BLOCK) {
                ImplicitAnnotationStrategy strategy;
                BlockState blockState = LytGuidebookScene.this.scene.getLevel().getBlockState(hitResult.getBlockPos());
                Iterator<ImplicitAnnotationStrategy> iterator = LytGuidebookScene.this.extensions.get(ImplicitAnnotationStrategy.EXTENSION_POINT).iterator();
                while (iterator.hasNext() && (annotation = (strategy = iterator.next()).getAnnotation(LytGuidebookScene.this.scene.getLevel(), blockState, hitResult)) == null) {
                }
                if (annotation == null) {
                    annotation = InWorldBoxAnnotation.forBlock(hitResult.getBlockPos(), SymbolicColor.IN_WORLD_BLOCK_HIGHLIGHT);
                    annotation.setTooltipContent((Component)Component.translatable((String)blockState.getBlock().getDescriptionId()));
                }
                this.setTransientHoveredAnnotation(annotation);
                if (annotation.getTooltip() != null) {
                    return Optional.of(annotation.getTooltip());
                }
                return Optional.empty();
            }
            this.setHoveredAnnotation(null);
            return Optional.empty();
        }

        @Override
        public boolean mouseClicked(GuideUiHost screen, int x, int y, int button) {
            if (LytGuidebookScene.this.interactive && (button == 0 || button == 1)) {
                CameraSettings cameraSettings = LytGuidebookScene.this.scene.getCameraSettings();
                this.buttonDown = button;
                this.pointDown = new Vector2i(x, y);
                this.initialRotX = cameraSettings.getRotationX();
                this.initialRotY = cameraSettings.getRotationY();
                this.initialTransX = cameraSettings.getOffsetX();
                this.initialTransY = cameraSettings.getOffsetY();
                screen.captureMouse(this);
            }
            return true;
        }

        @Override
        public boolean mouseReleased(GuideUiHost screen, int x, int y, int button) {
            this.pointDown = null;
            return true;
        }

        @Override
        public void mouseCaptureLost() {
            this.pointDown = null;
        }

        @Override
        public boolean mouseMoved(GuideUiHost screen, int x, int y) {
            if (LytGuidebookScene.this.interactive && this.pointDown != null) {
                int dx = x - this.pointDown.x;
                int dy = y - this.pointDown.y;
                if (this.buttonDown == 0) {
                    LytGuidebookScene.this.scene.getCameraSettings().setRotationY(this.initialRotY + (float)dx);
                    LytGuidebookScene.this.scene.getCameraSettings().setRotationX(this.initialRotX + (float)dy);
                } else if (this.buttonDown == 1) {
                    LytGuidebookScene.this.scene.getCameraSettings().setOffsetX(this.initialTransX + (float)dx);
                    LytGuidebookScene.this.scene.getCameraSettings().setOffsetY(this.initialTransY - (float)dy);
                }
                return true;
            }
            return false;
        }

        @Override
        public void onMouseLeave() {
            this.setHoveredAnnotation(null);
        }

        public boolean isHideAnnotations() {
            return this.hideAnnotations;
        }

        public void setHideAnnotations(boolean hideAnnotations) {
            this.hideAnnotations = hideAnnotations;
        }

        private void setTransientHoveredAnnotation(@Nullable SceneAnnotation annotation) {
            this.setHoveredAnnotation(null);
            this.setHoveredAnnotation(annotation);
            if (LytGuidebookScene.this.scene != null) {
                LytGuidebookScene.this.scene.addAnnotation(annotation);
            }
            this.transientHoveredAnnotation = true;
        }

        private void setHoveredAnnotation(@Nullable SceneAnnotation annotation) {
            if (this.hoveredAnnotation != annotation) {
                if (this.hoveredAnnotation != null) {
                    this.hoveredAnnotation.setHovered(false);
                    if (this.transientHoveredAnnotation) {
                        if (LytGuidebookScene.this.scene != null) {
                            LytGuidebookScene.this.scene.removeAnnotation(this.hoveredAnnotation);
                        }
                        this.transientHoveredAnnotation = false;
                    }
                }
                this.hoveredAnnotation = annotation;
                if (this.hoveredAnnotation != null) {
                    this.hoveredAnnotation.setHovered(true);
                }
            }
        }

        public void setBounds(LytRect bounds) {
            this.bounds = bounds;
            if (LytGuidebookScene.this.scene != null) {
                LytGuidebookScene.this.scene.getCameraSettings().setViewportSize(bounds.size());
            }
        }

        public LytSize getPreferredSize() {
            if (LytGuidebookScene.this.scene == null) {
                return LytSize.empty();
            }
            SavedCameraSettings current = LytGuidebookScene.this.scene.getCameraSettings().save();
            LytGuidebookScene.this.scene.getCameraSettings().restore(LytGuidebookScene.this.initialCameraSettings);
            Vector4f screenBounds = LytGuidebookScene.this.scene.getScreenBounds();
            LytGuidebookScene.this.scene.getCameraSettings().restore(current);
            int width = (int)Math.ceil(Math.abs(screenBounds.z - screenBounds.x));
            int height = (int)Math.ceil(Math.abs(screenBounds.w - screenBounds.y));
            return new LytSize(width, height);
        }

        private void renderOverlayAnnotations(GuidebookScene scene, RenderContext context) {
            for (OverlayAnnotation annotation : scene.getOverlayAnnotations()) {
                annotation.render(scene, context, this.bounds);
            }
        }
    }
}

