/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import guideme.document.LytRect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class RectangleMerger {
    public static List<LytRect> merge(List<LytRect> rects) {
        if (rects.isEmpty()) {
            return List.of();
        }
        ArrayList<LytRect> result = new ArrayList<LytRect>(rects.size());
        List<Event> xEvents = RectangleMerger.getSortedXEvents(rects);
        List<Event> yEvents = RectangleMerger.getSortedYEvents(rects);
        boolean[] currentSet = new boolean[rects.size()];
        for (int i = 0; i < xEvents.size() - 1; ++i) {
            Event xEvent = xEvents.get(i);
            currentSet[xEvent.ind] = xEvent.type == 0;
            Event nextXEvent = xEvents.get(i + 1);
            if (nextXEvent.x == xEvent.x) continue;
            int left = xEvent.x;
            int right = nextXEvent.x;
            int top = 0;
            int opened = 0;
            block1: for (int j = 0; j < yEvents.size(); ++j) {
                Event yEvent = yEvents.get(j);
                if (!currentSet[yEvent.ind]) continue;
                if (yEvent.type == 0) {
                    if (++opened != 1) continue;
                    top = yEvent.y;
                    continue;
                }
                if (--opened != 0) continue;
                for (int k = j + 1; k < yEvents.size(); ++k) {
                    Event nextEvent = yEvents.get(k);
                    if (!currentSet[nextEvent.ind] || nextEvent.type != 0) continue;
                    if (nextEvent.y != yEvent.y) break;
                    ++opened;
                    j = k;
                    continue block1;
                }
                result.add(new LytRect(left, top, right - left, yEvent.y - top));
            }
        }
        return result;
    }

    private static List<Event> getSortedXEvents(List<LytRect> rects) {
        ArrayList<Event> events = new ArrayList<Event>(rects.size() * 2);
        for (int i = 0; i < rects.size(); ++i) {
            LytRect rect = rects.get(i);
            events.add(new Event(i, 0, rect.x(), rect.y(), rect.width()));
            events.add(new Event(i, 1, rect.x() + rect.width(), rect.y(), rect.width()));
        }
        events.sort(Comparator.comparingInt(e -> e.x).thenComparingInt(e -> e.y));
        return events;
    }

    private static List<Event> getSortedYEvents(List<LytRect> rects) {
        ArrayList<Event> events = new ArrayList<Event>(rects.size() * 2);
        for (int i = 0; i < rects.size(); ++i) {
            LytRect rect = rects.get(i);
            events.add(new Event(i, 0, rect.x(), rect.y(), rect.height()));
            events.add(new Event(i, 1, rect.x(), rect.y() + rect.height(), rect.height()));
        }
        events.sort(Comparator.comparingInt(e -> e.y).thenComparingInt(e -> e.x));
        return events;
    }

    public record Event(int ind, int type, int x, int y, int length) {
    }
}

