/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.extensions;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.Extension;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.List;

public class YamlFrontmatterSyntax {
    public static final Extension INSTANCE;
    private static final Construct fenceConstruct;

    private static State tokenizeFrontmatter(final TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            StateMachine() {
            }

            State start(int code) {
                Point position = context.now();
                if (position.column() != 1 || position.line() != 1) {
                    return nok.step(code);
                }
                effects.enter("yaml");
                return effects.attempt.hook(fenceConstruct, this::afterOpeningFence, nok).step(code);
            }

            State afterOpeningFence(int code) {
                return this.lineEnd(code);
            }

            State lineStart(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    return this.lineEnd(code);
                }
                effects.enter("yamlValue");
                return this.lineData(code);
            }

            State lineData(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    effects.exit("yamlValue");
                    return this.lineEnd(code);
                }
                effects.consume(code);
                return this::lineData;
            }

            State lineEnd(int code) {
                if (code == Integer.MIN_VALUE) {
                    return nok.step(code);
                }
                effects.enter("lineEnding");
                effects.consume(code);
                effects.exit("lineEnding");
                return effects.attempt.hook(fenceConstruct, this::after, this::lineStart);
            }

            State after(int code) {
                effects.exit("yaml");
                return ok.step(code);
            }
        }
        return new StateMachine()::start;
    }

    private static State tokenizeFence(TokenizeContext context, final Tokenizer.Effects effects, final State ok, final State nok) {
        class StateMachine {
            int bufferIndex = 0;

            StateMachine() {
            }

            State start(int code) {
                if (code == "---".charAt(this.bufferIndex)) {
                    effects.enter("yamlFence");
                    effects.enter("yamlFenceSequence");
                    return this.insideSequence(code);
                }
                return nok.step(code);
            }

            State insideSequence(int code) {
                if (this.bufferIndex == "---".length()) {
                    effects.exit("yamlFenceSequence");
                    if (CharUtil.markdownSpace(code)) {
                        effects.enter("whitespace");
                        return this.insideWhitespace(code);
                    }
                    return this.fenceEnd(code);
                }
                if (code == "---".charAt(this.bufferIndex++)) {
                    effects.consume(code);
                    return this::insideSequence;
                }
                return nok.step(code);
            }

            State insideWhitespace(int code) {
                if (CharUtil.markdownSpace(code)) {
                    effects.consume(code);
                    return this::insideWhitespace;
                }
                effects.exit("whitespace");
                return this.fenceEnd(code);
            }

            State fenceEnd(int code) {
                if (code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                    effects.exit("yamlFence");
                    return ok.step(code);
                }
                return nok.step(code);
            }
        }
        return new StateMachine()::start;
    }

    static {
        fenceConstruct = new Construct();
        YamlFrontmatterSyntax.fenceConstruct.tokenize = YamlFrontmatterSyntax::tokenizeFence;
        YamlFrontmatterSyntax.fenceConstruct.partial = true;
        Construct construct = new Construct();
        construct.concrete = true;
        construct.tokenize = YamlFrontmatterSyntax::tokenizeFrontmatter;
        INSTANCE = new Extension();
        YamlFrontmatterSyntax.INSTANCE.flow.put(Integer.valueOf("---".charAt(0)), List.of(construct));
    }
}

