/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class HtmlText {
    public static final Construct htmlText = new Construct();

    static {
        HtmlText.htmlText.name = "htmlText";
        HtmlText.htmlText.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        @Nullable
        Integer marker;
        String buffer;
        private int index;
        State returnState;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 60, "expected `<`");
            this.effects.enter("htmlText");
            this.effects.enter("htmlTextData");
            this.effects.consume(code);
            return this::open;
        }

        private State open(int code) {
            if (code == 33) {
                this.effects.consume(code);
                return this::declarationOpen;
            }
            if (code == 47) {
                this.effects.consume(code);
                return this::tagCloseStart;
            }
            if (code == 63) {
                this.effects.consume(code);
                return this::instruction;
            }
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::tagOpen;
            }
            return this.nok.step(code);
        }

        private State declarationOpen(int code) {
            if (code == 45) {
                this.effects.consume(code);
                return this::commentOpenInside;
            }
            if (code == 91) {
                this.effects.consume(code);
                this.buffer = "CDATA[";
                this.index = 0;
                return this::cdataOpenInside;
            }
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::declaration;
            }
            return this.nok.step(code);
        }

        private State commentOpenInside(int code) {
            if (code == 45) {
                this.effects.consume(code);
                return this::commentStart;
            }
            return this.nok.step(code);
        }

        private State commentStart(int code) {
            if (code == 62) {
                return this.nok.step(code);
            }
            if (code == 45) {
                this.effects.consume(code);
                return this::commentStartDash;
            }
            return this.comment(code);
        }

        private State commentStartDash(int code) {
            if (code == 62) {
                return this.nok.step(code);
            }
            return this.comment(code);
        }

        private State comment(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (code == 45) {
                this.effects.consume(code);
                return this::commentClose;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::comment;
                return this.atLineEnding(code);
            }
            this.effects.consume(code);
            return this::comment;
        }

        private State commentClose(int code) {
            if (code == 45) {
                this.effects.consume(code);
                return this::end;
            }
            return this.comment(code);
        }

        private State cdataOpenInside(int code) {
            if (code == this.buffer.charAt(this.index++)) {
                this.effects.consume(code);
                return this.index == this.buffer.length() ? this::cdata : this::cdataOpenInside;
            }
            return this.nok.step(code);
        }

        private State cdata(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (code == 93) {
                this.effects.consume(code);
                return this::cdataClose;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::cdata;
                return this.atLineEnding(code);
            }
            this.effects.consume(code);
            return this::cdata;
        }

        private State cdataClose(int code) {
            if (code == 93) {
                this.effects.consume(code);
                return this::cdataEnd;
            }
            return this.cdata(code);
        }

        private State cdataEnd(int code) {
            if (code == 62) {
                return this.end(code);
            }
            if (code == 93) {
                this.effects.consume(code);
                return this::cdataEnd;
            }
            return this.cdata(code);
        }

        private State declaration(int code) {
            if (code == Integer.MIN_VALUE || code == 62) {
                return this.end(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::declaration;
                return this.atLineEnding(code);
            }
            this.effects.consume(code);
            return this::declaration;
        }

        private State instruction(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (code == 63) {
                this.effects.consume(code);
                return this::instructionClose;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::instruction;
                return this.atLineEnding(code);
            }
            this.effects.consume(code);
            return this::instruction;
        }

        private State instructionClose(int code) {
            return code == 62 ? this.end(code) : this.instruction(code);
        }

        private State tagCloseStart(int code) {
            if (CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::tagClose;
            }
            return this.nok.step(code);
        }

        private State tagClose(int code) {
            if (code == 45 || CharUtil.asciiAlphanumeric(code)) {
                this.effects.consume(code);
                return this::tagClose;
            }
            return this.tagCloseBetween(code);
        }

        private State tagCloseBetween(int code) {
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::tagCloseBetween;
                return this.atLineEnding(code);
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::tagCloseBetween;
            }
            return this.end(code);
        }

        private State tagOpen(int code) {
            if (code == 45 || CharUtil.asciiAlphanumeric(code)) {
                this.effects.consume(code);
                return this::tagOpen;
            }
            if (code == 47 || code == 62 || CharUtil.markdownLineEndingOrSpace(code)) {
                return this.tagOpenBetween(code);
            }
            return this.nok.step(code);
        }

        private State tagOpenBetween(int code) {
            if (code == 47) {
                this.effects.consume(code);
                return this::end;
            }
            if (code == 58 || code == 95 || CharUtil.asciiAlpha(code)) {
                this.effects.consume(code);
                return this::tagOpenAttributeName;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::tagOpenBetween;
                return this.atLineEnding(code);
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::tagOpenBetween;
            }
            return this.end(code);
        }

        private State tagOpenAttributeName(int code) {
            if (code == 45 || code == 46 || code == 58 || code == 95 || CharUtil.asciiAlphanumeric(code)) {
                this.effects.consume(code);
                return this::tagOpenAttributeName;
            }
            return this.tagOpenAttributeNameAfter(code);
        }

        private State tagOpenAttributeNameAfter(int code) {
            if (code == 61) {
                this.effects.consume(code);
                return this::tagOpenAttributeValueBefore;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::tagOpenAttributeNameAfter;
                return this.atLineEnding(code);
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::tagOpenAttributeNameAfter;
            }
            return this.tagOpenBetween(code);
        }

        private State tagOpenAttributeValueBefore(int code) {
            if (code == Integer.MIN_VALUE || code == 60 || code == 61 || code == 62 || code == 96) {
                return this.nok.step(code);
            }
            if (code == 34 || code == 39) {
                this.effects.consume(code);
                this.marker = code;
                return this::tagOpenAttributeValueQuoted;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::tagOpenAttributeValueBefore;
                return this.atLineEnding(code);
            }
            if (CharUtil.markdownSpace(code)) {
                this.effects.consume(code);
                return this::tagOpenAttributeValueBefore;
            }
            this.effects.consume(code);
            this.marker = null;
            return this::tagOpenAttributeValueUnquoted;
        }

        private State tagOpenAttributeValueQuoted(int code) {
            if (Objects.equals(code, this.marker)) {
                this.effects.consume(code);
                return this::tagOpenAttributeValueQuotedAfter;
            }
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.returnState = this::tagOpenAttributeValueQuoted;
                return this.atLineEnding(code);
            }
            this.effects.consume(code);
            return this::tagOpenAttributeValueQuoted;
        }

        private State tagOpenAttributeValueUnquoted(int code) {
            if (code == Integer.MIN_VALUE || code == 34 || code == 39 || code == 60 || code == 61 || code == 96) {
                return this.nok.step(code);
            }
            if (code == 62 || code == 47 || CharUtil.markdownLineEndingOrSpace(code)) {
                return this.tagOpenBetween(code);
            }
            this.effects.consume(code);
            return this::tagOpenAttributeValueUnquoted;
        }

        private State tagOpenAttributeValueQuotedAfter(int code) {
            if (code == 62 || code == 47 || CharUtil.markdownLineEndingOrSpace(code)) {
                return this.tagOpenBetween(code);
            }
            return this.nok.step(code);
        }

        private State end(int code) {
            if (code == 62) {
                this.effects.consume(code);
                this.effects.exit("htmlTextData");
                this.effects.exit("htmlText");
                return this.ok;
            }
            return this.nok.step(code);
        }

        private State atLineEnding(int code) {
            Assert.check(this.returnState != null, "expected return state");
            Assert.check(CharUtil.markdownLineEnding(code), "expected eol");
            this.effects.exit("htmlTextData");
            this.effects.enter("lineEnding");
            this.effects.consume(code);
            this.effects.exit("lineEnding");
            return FactorySpace.create(this.effects, this::afterPrefix, "linePrefix", this.context.getParser().constructs.nullDisable.contains("codeIndented") ? null : Integer.valueOf(4));
        }

        private State afterPrefix(int code) {
            this.effects.enter("htmlTextData");
            return this.returnState.step(code);
        }
    }
}

