/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.List;

public final class CodeText {
    public static final Construct codeText = new Construct();

    private static List<Tokenizer.Event> resolveCodeText(List<Tokenizer.Event> events, TokenizeContext context) {
        int index;
        int tailExitIndex = events.size() - 4;
        int headEnterIndex = 3;
        Integer enter = null;
        if ((events.get((int)headEnterIndex).token().type.equals("lineEnding") || events.get((int)headEnterIndex).token().type.equals("space")) && (events.get((int)tailExitIndex).token().type.equals("lineEnding") || events.get((int)tailExitIndex).token().type.equals("space"))) {
            index = headEnterIndex;
            while (++index < tailExitIndex) {
                if (!events.get((int)index).token().type.equals("codeTextData")) continue;
                events.get((int)headEnterIndex).token().type = "codeTextPadding";
                events.get((int)tailExitIndex).token().type = "codeTextPadding";
                headEnterIndex += 2;
                tailExitIndex -= 2;
                break;
            }
        }
        index = headEnterIndex - 1;
        ++tailExitIndex;
        while (++index <= tailExitIndex) {
            if (enter == null) {
                if (index == tailExitIndex || events.get((int)index).token().type.equals("lineEnding")) continue;
                enter = index;
                continue;
            }
            if (index != tailExitIndex && !events.get((int)index).token().type.equals("lineEnding")) continue;
            events.get((int)enter.intValue()).token().type = "codeTextData";
            if (index != enter + 2) {
                events.get((int)enter.intValue()).token().end = events.get((int)(index - 1)).token().end;
                events.subList(enter + 2, index).clear();
                tailExitIndex -= index - enter - 2;
                index = enter + 2;
            }
            enter = null;
        }
        return events;
    }

    private static boolean previous(TokenizeContext context, int code) {
        return code != 96 || context.getLastEvent().token().type.equals("characterEscape");
    }

    static {
        CodeText.codeText.name = "codeText";
        CodeText.codeText.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
        CodeText.codeText.resolve = CodeText::resolveCodeText;
        CodeText.codeText.previous = CodeText::previous;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        int sizeOpen;
        private int size;
        private Token token;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 96, "expected `` ` ``");
            Assert.check(CodeText.previous(this.context, this.context.getPrevious()), "expected correct previous");
            this.effects.enter("codeText");
            this.effects.enter("codeTextSequence");
            return this.sequenceOpen(code);
        }

        private State sequenceOpen(int code) {
            if (code == 96) {
                this.effects.consume(code);
                ++this.sizeOpen;
                return this::sequenceOpen;
            }
            this.effects.exit("codeTextSequence");
            return this.between(code);
        }

        private State between(int code) {
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (code == 96) {
                this.token = this.effects.enter("codeTextSequence");
                this.size = 0;
                return this.sequenceClose(code);
            }
            if (code == 32) {
                this.effects.enter("space");
                this.effects.consume(code);
                this.effects.exit("space");
                return this::between;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.enter("lineEnding");
                this.effects.consume(code);
                this.effects.exit("lineEnding");
                return this::between;
            }
            this.effects.enter("codeTextData");
            return this.data(code);
        }

        private State data(int code) {
            if (code == Integer.MIN_VALUE || code == 32 || code == 96 || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("codeTextData");
                return this.between(code);
            }
            this.effects.consume(code);
            return this::data;
        }

        private State sequenceClose(int code) {
            if (code == 96) {
                this.effects.consume(code);
                ++this.size;
                return this::sequenceClose;
            }
            if (this.size == this.sizeOpen) {
                this.effects.exit("codeTextSequence");
                this.effects.exit("codeText");
                return this.ok.step(code);
            }
            this.token.type = "codeTextData";
            return this.data(code);
        }
    }
}

