/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Arrays;

public final class LongBitSet
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(LongBitSet.class);
    private final long[] bits;
    private final long numBits;
    private final int numWords;
    public static final long MAX_NUM_BITS = 64L * (long)ArrayUtil.MAX_ARRAY_LENGTH;

    public static int bits2words(long numBits) {
        if (numBits < 0L || numBits > MAX_NUM_BITS) {
            throw new IllegalArgumentException("numBits must be 0 .. " + MAX_NUM_BITS + "; got: " + numBits);
        }
        return (int)(numBits - 1L >> 6) + 1;
    }

    public LongBitSet(long numBits) {
        this.numBits = numBits;
        this.bits = new long[LongBitSet.bits2words(numBits)];
        this.numWords = this.bits.length;
    }

    public LongBitSet(long[] storedBits, long numBits) {
        this.numWords = LongBitSet.bits2words(numBits);
        if (this.numWords > storedBits.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + numBits + " bits");
        }
        this.numBits = numBits;
        this.bits = storedBits;
        assert (this.verifyGhostBitsClear());
    }

    private boolean verifyGhostBitsClear() {
        for (int i = this.numWords; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3FL) == 0L) {
            return true;
        }
        long mask = -1L << (int)this.numBits;
        return (this.bits[this.numWords - 1] & mask) == 0L;
    }

    public long cardinality() {
        long tot = 0L;
        for (int i = 0; i < this.numWords; ++i) {
            tot += (long)Long.bitCount(this.bits[i]);
        }
        return tot;
    }

    public boolean get(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + ", numBits=" + this.numBits;
        int i = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        return (this.bits[i] & bitmask) != 0L;
    }

    public void set(long index) {
        assert (index >= 0L && index < this.numBits) : "index=" + index + " numBits=" + this.numBits;
        int wordNum = (int)(index >> 6);
        long bitmask = 1L << (int)index;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public LongBitSet clone() {
        long[] bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bits, 0, this.numWords);
        return new LongBitSet(bits, this.numBits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongBitSet)) {
            return false;
        }
        LongBitSet other = (LongBitSet)o;
        if (this.numBits != other.numBits) {
            return false;
        }
        return Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        long h = 0L;
        int i = this.numWords;
        while (--i >= 0) {
            h ^= this.bits[i];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.bits);
    }
}

