/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.FlushInfo;
import guideme.internal.shaded.lucene.store.MergeInfo;
import guideme.internal.shaded.lucene.store.ReadAdvice;
import guideme.internal.shaded.lucene.util.Constants;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Objects;

public final class IOContext
extends Record {
    private final Context context;
    private final MergeInfo mergeInfo;
    private final FlushInfo flushInfo;
    private final ReadAdvice readAdvice;
    public static final IOContext DEFAULT = new IOContext(Constants.DEFAULT_READADVICE);
    public static final IOContext READONCE = new IOContext(ReadAdvice.SEQUENTIAL);
    private static final IOContext[] READADVICE_TO_IOCONTEXT = (IOContext[])Arrays.stream(ReadAdvice.values()).map(IOContext::new).toArray(IOContext[]::new);

    public IOContext(Context context, MergeInfo mergeInfo, FlushInfo flushInfo, ReadAdvice readAdvice) {
        Objects.requireNonNull(context, "context must not be null");
        Objects.requireNonNull(readAdvice, "readAdvice must not be null");
        switch (context.ordinal()) {
            case 0: {
                Objects.requireNonNull(mergeInfo, "mergeInfo must not be null if context is MERGE");
                break;
            }
            case 1: {
                Objects.requireNonNull(flushInfo, "flushInfo must not be null if context is FLUSH");
            }
        }
        if ((context == Context.FLUSH || context == Context.MERGE) && readAdvice != ReadAdvice.SEQUENTIAL) {
            throw new IllegalArgumentException("The FLUSH and MERGE contexts must use the SEQUENTIAL read access advice");
        }
        this.context = context;
        this.mergeInfo = mergeInfo;
        this.flushInfo = flushInfo;
        this.readAdvice = readAdvice;
    }

    private IOContext(ReadAdvice accessAdvice) {
        this(Context.DEFAULT, null, null, accessAdvice);
    }

    public IOContext(FlushInfo flushInfo) {
        this(Context.FLUSH, null, flushInfo, ReadAdvice.SEQUENTIAL);
    }

    public IOContext(MergeInfo mergeInfo) {
        this(Context.MERGE, mergeInfo, null, ReadAdvice.SEQUENTIAL);
    }

    public IOContext withReadAdvice(ReadAdvice advice) {
        if (this.context == Context.DEFAULT) {
            return READADVICE_TO_IOCONTEXT[advice.ordinal()];
        }
        return this;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IOContext.class, "context;mergeInfo;flushInfo;readAdvice", "context", "mergeInfo", "flushInfo", "readAdvice"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IOContext.class, "context;mergeInfo;flushInfo;readAdvice", "context", "mergeInfo", "flushInfo", "readAdvice"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IOContext.class, "context;mergeInfo;flushInfo;readAdvice", "context", "mergeInfo", "flushInfo", "readAdvice"}, this, o);
    }

    public Context context() {
        return this.context;
    }

    public ReadAdvice readAdvice() {
        return this.readAdvice;
    }

    public static enum Context {
        MERGE,
        FLUSH,
        DEFAULT;

    }
}

